/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.management.daos.PermissionsDao;
import de.alpharogroup.user.management.entities.Permissions;
import de.alpharogroup.user.management.factories.UserManagementFactory;
import de.alpharogroup.user.management.service.api.PermissionsService;
import de.alpharogroup.user.management.service.util.HqlStringCreator;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="permissionsService")
public class PermissionsBusinessService
extends AbstractBusinessService<Permissions, Integer, PermissionsDao>
implements PermissionsService {
    private static final long serialVersionUID = 1L;

    @Autowired
    public void setPermissionsDao(PermissionsDao permissionsDao) {
        this.setDao((EntityManagerDao)permissionsDao);
    }

    @Override
    public Permissions createAndSavePermissions(String name, String description) {
        return this.createAndSavePermissions(name, description, null);
    }

    @Override
    public Permissions createAndSavePermissions(String name, String description, String shortcut) {
        Permissions permissions = UserManagementFactory.getInstance().newPermissions(name, description, shortcut);
        permissions = (Permissions)this.merge((BaseEntity)permissions);
        return permissions;
    }

    @Override
    public Permissions findByShortcut(String shortcut) {
        return (Permissions)ListExtensions.getFirst(this.find(null, null, shortcut));
    }

    @Override
    public Permissions findByName(String name) {
        return (Permissions)ListExtensions.getFirst(this.find(null, name, null));
    }

    @Override
    public List<Permissions> find(String description, String permissionName, String shortcut) {
        String hqlString = HqlStringCreator.forPermissions(description, permissionName, shortcut);
        Query query = this.getQuery(hqlString);
        if (description != null) {
            query.setParameter("description", (Object)description);
        }
        if (permissionName != null) {
            query.setParameter("permissionName", (Object)permissionName);
        }
        if (shortcut != null) {
            query.setParameter("shortcut", (Object)shortcut);
        }
        List permissions = query.getResultList();
        return permissions;
    }
}

