/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service.api;

import de.alpharogroup.auth.models.AuthenticationErrors;
import de.alpharogroup.auth.models.AuthenticationResult;
import de.alpharogroup.crypto.pw.PasswordEncryptor;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.service.api.UsersManagementService;
import java.io.Serializable;
import java.io.UnsupportedEncodingException;
import java.security.InvalidAlgorithmParameterException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.spec.InvalidKeySpecException;
import javax.crypto.BadPaddingException;
import javax.crypto.IllegalBlockSizeException;
import javax.crypto.NoSuchPaddingException;

public interface AuthenticationsService
extends Serializable {
    default public AuthenticationResult<Users, AuthenticationErrors> authenticate(String emailOrUsername, String password) {
        AuthenticationResult authenticationResult = new AuthenticationResult();
        UsersManagementService userManagementBusinessService = this.getUsersManagementService();
        boolean emailExists = userManagementBusinessService.existsUserWithEmail(emailOrUsername);
        if (emailExists) {
            Users user = userManagementBusinessService.findUserWithEmail(emailOrUsername);
            return this.authorize(user, password, (AuthenticationResult<Users, AuthenticationErrors>)authenticationResult);
        }
        boolean usernameExists = userManagementBusinessService.existsUserWithUsername(emailOrUsername);
        if (usernameExists) {
            Users user = userManagementBusinessService.findUserWithUsername(emailOrUsername);
            return this.authorize(user, password, (AuthenticationResult<Users, AuthenticationErrors>)authenticationResult);
        }
        authenticationResult.getValidationErrors().add(AuthenticationErrors.EMAIL_OR_USERNAME_DOES_NOT_EXIST);
        return authenticationResult;
    }

    default public AuthenticationResult<Users, AuthenticationErrors> authorize(Users user, String password, AuthenticationResult<Users, AuthenticationErrors> authenticationResult) {
        if (user != null && user.isActive()) {
            String hashedPassword = "";
            String dbHashedPassword = user.getPw();
            String salt = user.getSalt();
            PasswordEncryptor passwordService = PasswordEncryptor.getInstance();
            try {
                hashedPassword = passwordService.hashAndHexPassword(password, salt);
            }
            catch (UnsupportedEncodingException | InvalidAlgorithmParameterException | InvalidKeyException | NoSuchAlgorithmException | InvalidKeySpecException | BadPaddingException | IllegalBlockSizeException | NoSuchPaddingException e) {
                authenticationResult.getValidationErrors().add(AuthenticationErrors.PASSWORD_INVALID);
                return authenticationResult;
            }
            if (passwordService.match(hashedPassword, dbHashedPassword)) {
                authenticationResult.setUser((Object)user);
            } else {
                authenticationResult.getValidationErrors().add(AuthenticationErrors.PASSWORD_INVALID);
            }
        } else {
            authenticationResult.getValidationErrors().add(AuthenticationErrors.UNREGISTERED);
        }
        return authenticationResult;
    }

    public UsersManagementService getUsersManagementService();

    public String newAuthenticationToken(String var1);
}

