/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.address.book.service.api.AddressesService;
import de.alpharogroup.auth.enums.InsertUserState;
import de.alpharogroup.auth.exceptions.EmailAlreadyExistsException;
import de.alpharogroup.auth.exceptions.UserAlreadyExistsException;
import de.alpharogroup.auth.models.UsernameSignUpModel;
import de.alpharogroup.auth.models.ValidationErrors;
import de.alpharogroup.crypto.pw.PasswordEncryptor;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.random.RandomExtensions;
import de.alpharogroup.resource.system.application.model.ModelSynchronizer;
import de.alpharogroup.resource.system.application.model.ResourcesModel;
import de.alpharogroup.resource.system.entities.Resources;
import de.alpharogroup.resource.system.service.api.ResourcesService;
import de.alpharogroup.user.entities.Roles;
import de.alpharogroup.user.entities.UserTokens;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.entities.Contactmethods;
import de.alpharogroup.user.management.entities.UserDatas;
import de.alpharogroup.user.management.enums.ContactmethodType;
import de.alpharogroup.user.management.factories.UserManagementFactory;
import de.alpharogroup.user.management.service.api.ContactmethodsService;
import de.alpharogroup.user.management.service.api.UserDatasService;
import de.alpharogroup.user.management.service.api.UsersManagementService;
import de.alpharogroup.user.management.service.api.UsersService;
import de.alpharogroup.user.management.sign.up.SignUpUserResult;
import de.alpharogroup.user.management.sign.up.UserModel;
import de.alpharogroup.user.service.api.RolesService;
import de.alpharogroup.user.service.api.UserTokensService;
import java.io.Serializable;
import java.sql.BatchUpdateException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.annotation.Nonnull;
import org.apache.log4j.Logger;
import org.hibernate.HibernateException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="usersManagementService")
public class UsersManagementBusinessService
implements UsersManagementService {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger((String)UsersManagementBusinessService.class.getName());
    @Autowired
    private AddressesService addressesService;
    @Autowired
    private ContactmethodsService contactmethodsService;
    @Autowired
    private RolesService rolesService;
    @Autowired
    private UsersService usersService;
    @Autowired
    private UserDatasService userDatasService;
    @Autowired
    private UserTokensService userTokensService;
    @Autowired
    private ResourcesService resourcesService;

    @Override
    public Users addUserContact(Users user, Users contact) {
        UserDatas userData = this.userDatasService.findBy(user);
        userData.getUserContacts().add(contact);
        userData = (UserDatas)this.getUserDatasService().merge((BaseEntity)userData);
        return user;
    }

    @Override
    public UserDatas deleteAddress(Addresses address, UserDatas ud) {
        UserDatas userData = (UserDatas)this.userDatasService.get(ud.getId());
        if (userData.getAddresses().contains(address)) {
            userData.getAddresses().remove(address);
            userData = (UserDatas)this.userDatasService.merge((BaseEntity)userData);
        }
        return userData;
    }

    @Override
    public UserDatas deleteBlacklisted(Users blacklisted, Integer userDataId) {
        UserDatas userData = (UserDatas)this.userDatasService.get(userDataId);
        if (userData.getBlacklistedContacts().contains(blacklisted)) {
            try {
                userData.getBlacklistedContacts().remove(blacklisted);
                userData = (UserDatas)this.userDatasService.merge((BaseEntity)userData);
            }
            catch (HibernateException e) {
                LOGGER.error((Object)"HibernateException on flush...", (Throwable)e);
            }
        }
        return userData;
    }

    @Override
    public void deleteResource(ResourcesModel resourceModel, Integer userDataId) {
        UserDatas userData = (UserDatas)this.userDatasService.get(userDataId);
        Resources resource = (Resources)this.resourcesService.get((Serializable)resourceModel.getId());
        if (userData.getResources().contains(resource)) {
            if (userData.getResources().remove(resource)) {
                userData = (UserDatas)this.userDatasService.merge((BaseEntity)userData);
            }
            try {
                if (this.resourcesService.exists(resource.getId())) {
                    resource.setDeletedFlag(Boolean.TRUE);
                    resource = (Resources)this.resourcesService.merge((BaseEntity)resource);
                }
            }
            catch (HibernateException e) {
                LOGGER.error((Object)"Error by flushing...", (Throwable)e);
            }
        }
    }

    @Override
    public boolean existsUserWithEmail(Contactmethods emailContact) {
        boolean emailExists = this.contactmethodsService.existsContact(emailContact);
        return emailExists;
    }

    public boolean existsUserWithEmail(String email) {
        Contactmethods emailContact = UserManagementFactory.getInstance().newContactmethods(ContactmethodType.EMAIL, email);
        return this.existsUserWithEmail(emailContact);
    }

    public boolean existsUserWithEmailOrUsername(String emailOrUsername) {
        boolean emailExists = this.usersService.findUserWithEmail(emailOrUsername) != null;
        return emailExists || this.existsUserWithUsername(emailOrUsername);
    }

    public InsertUserState existsUserWithEmailOrUsername(String email, String username) {
        if (this.existsUserWithEmail(email)) {
            return InsertUserState.EMAIL_EXISTS;
        }
        if (this.existsUserWithUsername(username)) {
            return InsertUserState.USERNAME_EXISTS;
        }
        return InsertUserState.INSERT;
    }

    public boolean existsUserWithUsername(String username) {
        return this.usersService.existsUserWithUsername(username);
    }

    @Override
    public List<Addresses> findAddessesFromUser(Users user) {
        return this.usersService.findAddressesFromUser(user);
    }

    @Override
    public Addresses findAddressFromUser(Users user) {
        return this.usersService.findAddressFromUser(user);
    }

    @Override
    public List<Contactmethods> findAllContactmethodsByType(@Nonnull Users user, @Nonnull ContactmethodType contactmethodType) {
        ArrayList<Contactmethods> cms = new ArrayList<Contactmethods>();
        UserDatas userData = this.userDatasService.findBy(user);
        Set userContactMethods = userData.getContactmethods();
        for (Contactmethods cm : userContactMethods) {
            if (!contactmethodType.equals((Object)cm.getContactmethod())) continue;
            cms.add(cm);
        }
        return cms;
    }

    @Override
    public List<Contactmethods> findAllEmailContactmethodsFromUser(Users user) {
        return this.findAllContactmethodsByType(user, ContactmethodType.EMAIL);
    }

    @Override
    public List<Contactmethods> findAllFaxContactmethodsFromUser(Users user) {
        return this.findAllContactmethodsByType(user, ContactmethodType.FAX);
    }

    @Override
    public List<Contactmethods> findAllInternetContactmethodsFromUser(Users user) {
        return this.findAllContactmethodsByType(user, ContactmethodType.INTERNET);
    }

    @Override
    public List<Contactmethods> findAllMobileContactmethodsFromUser(Users user) {
        return this.findAllContactmethodsByType(user, ContactmethodType.MOBILE);
    }

    @Override
    public List<Contactmethods> findAllTelefonContactmethodsFromUser(Users user) {
        return this.findAllContactmethodsByType(user, ContactmethodType.TELEFON);
    }

    @Override
    public Contactmethods findContactmethodByType(@Nonnull Users user, @Nonnull ContactmethodType contactmethodType) {
        UserDatas userData = this.userDatasService.findBy(user);
        Set userContactMethods = userData.getContactmethods();
        for (Contactmethods cm : userContactMethods) {
            ContactmethodType currentContactmethodType = cm.getContactmethod();
            if (!contactmethodType.equals((Object)currentContactmethodType)) continue;
            return cm;
        }
        return null;
    }

    @Override
    public Contactmethods findEmailContactFromUser(Users user) {
        return this.findContactmethodByType(user, ContactmethodType.EMAIL);
    }

    @Override
    public Contactmethods findFaxContactFromUser(Users user) {
        return this.findContactmethodByType(user, ContactmethodType.FAX);
    }

    @Override
    public Contactmethods findInternetContactFromUser(Users user) {
        return this.findContactmethodByType(user, ContactmethodType.INTERNET);
    }

    @Override
    public Contactmethods findMobileContactFromUser(Users user) {
        return this.findContactmethodByType(user, ContactmethodType.MOBILE);
    }

    @Override
    public List<Roles> findRolesFromUser(Users user) {
        return this.usersService.findRolesFromUser(user);
    }

    @Override
    public Contactmethods findTelefonContactFromUser(Users user) {
        return this.findContactmethodByType(user, ContactmethodType.TELEFON);
    }

    @Override
    public Users findUserWithEmail(String email) {
        return this.usersService.findUserWithEmail(email);
    }

    @Override
    public Users findUserWithEmailOrUsername(String emailOrUsername) {
        Users user = this.findUserWithEmail(emailOrUsername);
        if (user != null) {
            return user;
        }
        return this.findUserWithUsername(emailOrUsername);
    }

    @Override
    public Users findUserWithUsername(String username) {
        return this.usersService.findUserWithUsername(username);
    }

    @Override
    public boolean isInRole(String rolename, List<Roles> roles) {
        if (null != roles && !roles.isEmpty()) {
            for (Roles role : roles) {
                if (!role.getRolename().equals(rolename)) continue;
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isUserInRole(Users user, String rolename) {
        return this.isInRole(rolename, this.findRolesFromUser(user));
    }

    @Override
    public boolean isValid(String token) {
        return this.userTokensService.isValid(token);
    }

    @Override
    public String newAuthenticationToken(String username) {
        UserTokens userTokens = this.userTokensService.find(username);
        if (userTokens == null) {
            userTokens = (UserTokens)this.userTokensService.merge((BaseEntity)this.newUserTokens(username));
        }
        Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        if (userTokens.getExpiry().before(now)) {
            Date expiry = Date.from(LocalDateTime.now().plusMonths(12L).atZone(ZoneId.systemDefault()).toInstant());
            String token = RandomExtensions.randomToken();
            userTokens.setExpiry(expiry);
            userTokens.setToken(token);
            userTokens = (UserTokens)this.userTokensService.merge((BaseEntity)userTokens);
        }
        return userTokens.getToken();
    }

    private UserTokens newUserTokens(String username) {
        Date expiry = Date.from(LocalDateTime.now().plusMonths(12L).atZone(ZoneId.systemDefault()).toInstant());
        String token = RandomExtensions.randomToken();
        UserTokens userTokens = UserTokens.builder().expiry(expiry).username(username).token(token).build();
        return userTokens;
    }

    @Override
    public Resources persistResource(ResourcesModel resourceModel, Integer userId) {
        Users user = (Users)this.usersService.get(userId);
        Resources resource = ModelSynchronizer.convert((ResourcesModel)resourceModel);
        resource = (Resources)this.resourcesService.merge((BaseEntity)resource);
        resourceModel.setId((Integer)resource.getId());
        UserDatas userData = this.userDatasService.findBy(user);
        userData.getResources().add(resource);
        userData = (UserDatas)this.userDatasService.merge((BaseEntity)userData);
        try {
            user = (Users)this.usersService.merge((BaseEntity)user);
        }
        catch (HibernateException e) {
            LOGGER.error((Object)"Error by flushing...", (Throwable)e);
        }
        return resource;
    }

    @Override
    public void saveAddressesFromUser(Users user, Collection<Addresses> addresses) {
        ArrayList<Addresses> mergedAddresses = new ArrayList<Addresses>();
        for (Addresses address : addresses) {
            if (!this.addressesService.exists(address.getId())) {
                address = (Addresses)this.addressesService.merge((BaseEntity)address);
            }
            mergedAddresses.add(address);
        }
        UserDatas userData = this.userDatasService.findBy(user);
        userData.getAddresses().addAll(mergedAddresses);
        userData = (UserDatas)this.userDatasService.merge((BaseEntity)userData);
    }

    @Override
    public void saveAddressFromUser(Users user, Addresses address) {
        if (!this.addressesService.exists(address.getId())) {
            address = (Addresses)this.addressesService.merge((BaseEntity)address);
        }
        UserDatas userData = this.userDatasService.findBy(user);
        userData.getAddresses().add(address);
        userData = (UserDatas)this.userDatasService.merge((BaseEntity)userData);
    }

    @Override
    public Integer saveNewUser(Users user) throws UserAlreadyExistsException {
        String username = user.getUsername();
        if (username == null || username.isEmpty()) {
            throw new IllegalArgumentException("Username cannot be null or empty");
        }
        boolean exists = this.existsUserWithUsername(username);
        if (!exists) {
            Users mergedUser = (Users)this.usersService.merge((BaseEntity)user);
            return (Integer)mergedUser.getId();
        }
        throw new UserAlreadyExistsException("User with username " + username + " allready exists.");
    }

    @Override
    public Integer saveUserOnlyWithEmail(Users user) {
        Users mergedUser = (Users)this.usersService.merge((BaseEntity)user);
        return (Integer)mergedUser.getId();
    }

    @Override
    public Contactmethods saveUserWithContactmethod(Users user, Contactmethods contact) throws BatchUpdateException {
        Contactmethods saved = (Contactmethods)this.contactmethodsService.merge((BaseEntity)contact);
        UserDatas ud = this.userDatasService.findBy(user);
        ud.getContactmethods().add(saved);
        ud = (UserDatas)this.userDatasService.merge((BaseEntity)ud);
        return saved;
    }

    @Override
    public List<Contactmethods> saveUserWithContactmethods(Users user, List<Contactmethods> contacts) throws BatchUpdateException {
        List saved = this.contactmethodsService.merge(contacts);
        UserDatas ud = this.userDatasService.findBy(user);
        ud.getContactmethods().addAll(saved);
        ud = (UserDatas)this.userDatasService.merge((BaseEntity)ud);
        return saved;
    }

    @Override
    public void saveUserWithRoles(Users user, Collection<Roles> roles) {
        ArrayList<Roles> mergedRoles = new ArrayList<Roles>();
        for (Roles role : roles) {
            if (!this.rolesService.exists(role.getId())) {
                role = (Roles)this.rolesService.merge((BaseEntity)role);
            }
            mergedRoles.add(role);
        }
        user.getRoles().addAll(roles);
        user = (Users)this.usersService.merge((BaseEntity)user);
    }

    @Override
    public Contactmethods setEmail(String email, Users user) throws EmailAlreadyExistsException {
        Contactmethods emailContact = UserManagementFactory.getInstance().newContactmethods(ContactmethodType.EMAIL, email);
        Contactmethods emailContactInDB = this.findEmailContactFromUser(user);
        if (emailContactInDB == null) {
            return emailContact;
        }
        if (!this.contactmethodsService.compare(emailContact, emailContactInDB)) {
            if (this.existsUserWithEmail(email)) {
                throw new EmailAlreadyExistsException("User with email " + email + " already exists");
            }
            emailContactInDB.setContactvalue(emailContact.getContactvalue());
            return emailContactInDB;
        }
        return emailContactInDB;
    }

    @Override
    public boolean setUsername(String username, Users user) throws UserAlreadyExistsException {
        if (this.existsUserWithUsername(username)) {
            throw new UserAlreadyExistsException("User with username " + username + " already exists");
        }
        user.setUsername(username);
        return true;
    }

    @Override
    @Transactional(rollbackFor={Exception.class})
    public SignUpUserResult signUpUser(UsernameSignUpModel model, Set<Roles> roles, UserModel userModel) {
        Addresses address;
        String hashedPassword;
        SignUpUserResult result = new SignUpUserResult();
        String username = model.getUsername();
        String email = model.getEmail();
        String password = model.getPassword();
        ValidationErrors validationErrors = this.validate(model);
        if (validationErrors != null) {
            result.setValidationErrors(validationErrors);
            return result;
        }
        HashSet<Contactmethods> contacts = new HashSet<Contactmethods>();
        Contactmethods emailContact = UserManagementFactory.getInstance().newContactmethods(ContactmethodType.EMAIL, email);
        contacts.add(emailContact);
        if (userModel.getFax() != null && !userModel.getFax().isEmpty()) {
            Contactmethods faxContact = UserManagementFactory.getInstance().newContactmethods(ContactmethodType.FAX, userModel.getFax());
            contacts.add(faxContact);
        }
        if (userModel.getTelefon() != null && !userModel.getTelefon().isEmpty()) {
            Contactmethods telefonContact = UserManagementFactory.getInstance().newContactmethods(ContactmethodType.TELEFON, userModel.getTelefon());
            contacts.add(telefonContact);
        }
        if (userModel.getMobile() != null && !userModel.getMobile().isEmpty()) {
            Contactmethods mobileContact = UserManagementFactory.getInstance().newContactmethods(ContactmethodType.MOBILE, userModel.getMobile());
            contacts.add(mobileContact);
        }
        Users newUser = null;
        PasswordEncryptor passwordService = PasswordEncryptor.getInstance();
        String salt = passwordService.getRandomSalt(8);
        try {
            hashedPassword = passwordService.hashAndHexPassword(password, salt);
        }
        catch (Exception e) {
            throw new IllegalArgumentException(e);
        }
        String locale = null;
        if (userModel.getLocale() != null && 5 < (locale = userModel.getLocale().toString()).length()) {
            locale = locale.substring(0, 5);
        }
        newUser = UserManagementFactory.getInstance().newUsers(Boolean.TRUE, hashedPassword, salt, username, Boolean.FALSE, roles);
        newUser = (Users)this.usersService.merge((BaseEntity)newUser);
        UserDatas userData = UserManagementFactory.getInstance().newUserData(userModel.getBirthname(), userModel.getDateofbirth(), userModel.getFirstname(), userModel.getGender(), userModel.getIpAddress(), userModel.getLastname(), locale);
        userData.setOwner(newUser);
        HashSet<Contactmethods> mergedContacts = new HashSet<Contactmethods>();
        for (Contactmethods contactmethod : contacts) {
            contactmethod = (Contactmethods)this.contactmethodsService.merge((BaseEntity)contactmethod);
            mergedContacts.add(contactmethod);
        }
        userData.setContactmethods(mergedContacts);
        userData = (UserDatas)this.userDatasService.merge((BaseEntity)userData);
        if (userModel.getAddress() != null && (address = (Addresses)this.addressesService.merge((BaseEntity)userModel.getAddress())) != null) {
            userData.setPrimaryAddress(address);
        }
        userData = (UserDatas)this.userDatasService.merge((BaseEntity)userData);
        result.setUser(newUser);
        return result;
    }

    @Override
    public Contactmethods updateContactmethod(String contactmethodValue, ContactmethodType contactmethodType, Contactmethods contactmethod) {
        Contactmethods newContactMethod = UserManagementFactory.getInstance().newContactmethods(contactmethodType, contactmethodValue);
        if (contactmethod != null && !this.contactmethodsService.compare(newContactMethod, contactmethod)) {
            contactmethod.setContactvalue(contactmethodValue);
            return contactmethod;
        }
        return newContactMethod;
    }

    @Override
    public boolean updateUsername(String username, Users user) throws UserAlreadyExistsException {
        boolean result = false;
        if (!user.getUsername().equals(username.trim())) {
            result = this.setUsername(username, user);
        }
        return result;
    }

    @Override
    public boolean userIsInRole(Users user, Roles role) {
        return this.usersService.userIsInRole(user, role);
    }

    @Override
    public ValidationErrors validate(UsernameSignUpModel model) {
        String password = model.getPassword();
        String repeatPassword = model.getRepeatPassword();
        if (!model.getTermOfUseAccepted().booleanValue()) {
            return ValidationErrors.TERM_OF_USE_ERROR;
        }
        if (this.existsUserWithEmail(model.getEmail())) {
            return ValidationErrors.EMAIL_EXISTS_ERROR;
        }
        if (this.existsUserWithUsername(model.getUsername())) {
            return ValidationErrors.USERNAME_EXISTS_ERROR;
        }
        if (!password.trim().equals(repeatPassword.trim())) {
            return ValidationErrors.UNEQAUL_PASSWORDS_ERROR;
        }
        return null;
    }

    public ContactmethodsService getContactmethodsService() {
        return this.contactmethodsService;
    }

    public void setContactmethodsService(ContactmethodsService contactmethodsService) {
        this.contactmethodsService = contactmethodsService;
    }

    public RolesService getRolesService() {
        return this.rolesService;
    }

    public void setRolesService(RolesService rolesService) {
        this.rolesService = rolesService;
    }

    public UsersService getUsersService() {
        return this.usersService;
    }

    public void setUsersService(UsersService usersService) {
        this.usersService = usersService;
    }

    public UserDatasService getUserDatasService() {
        return this.userDatasService;
    }

    public void setUserDatasService(UserDatasService userDatasService) {
        this.userDatasService = userDatasService;
    }

    public UserTokensService getUserTokensService() {
        return this.userTokensService;
    }

    public void setUserTokensService(UserTokensService userTokensService) {
        this.userTokensService = userTokensService;
    }
}

