/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.address.book.service.util.HqlStringCreator;
import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.date.CalculateDateExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.jgeohash.GeoHashExtensions;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.daos.UserDatasDao;
import de.alpharogroup.user.management.entities.UserDatas;
import de.alpharogroup.user.management.enums.GenderType;
import de.alpharogroup.user.management.service.api.UserDatasService;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="userDatasService")
public class UserDatasBusinessService
extends AbstractBusinessService<UserDatas, Integer, UserDatasDao>
implements UserDatasService {
    private static final long serialVersionUID = 1L;
    private static final Logger LOGGER = Logger.getLogger((String)UserDatasBusinessService.class.getName());

    @Override
    public UserDatas findBy(Integer userid) {
        String hqlString = "select ud from UserDatas ud where ud.owner.id=:userid";
        Query query = this.getQuery("select ud from UserDatas ud where ud.owner.id=:userid");
        query.setParameter("userid", (Object)userid);
        List userDatas = query.getResultList();
        return (UserDatas)ListExtensions.getFirst((List)userDatas);
    }

    @Override
    public UserDatas findBy(Users user) {
        String hqlString = "select ud from UserDatas ud where ud.owner=:user";
        Query query = this.getQuery("select ud from UserDatas ud where ud.owner=:user");
        query.setParameter("user", (Object)user);
        List userDatas = query.getResultList();
        return (UserDatas)ListExtensions.getFirst((List)userDatas);
    }

    @Override
    public List<UserDatas> findUserDatas(Integer from, GenderType searchGender, Integer until) {
        Date now = new Date(System.currentTimeMillis());
        Date start = CalculateDateExtensions.substractYearsFromDate((Date)now, (int)until);
        Date end = CalculateDateExtensions.substractYearsFromDate((Date)now, (int)from);
        String hqlString = "select ud from UserDatas ud where ud.gender=:gender and ud.dateofbirth >= :start and ud.dateofbirth <= :end";
        Query query = this.getQuery("select ud from UserDatas ud where ud.gender=:gender and ud.dateofbirth >= :start and ud.dateofbirth <= :end");
        query.setParameter("gender", (Object)searchGender);
        query.setParameter("start", (Object)start);
        query.setParameter("end", (Object)end);
        List userDatas = query.getResultList();
        return userDatas;
    }

    @Override
    public List<UserDatas> findUserDatas(Integer from, GenderType searchGender, Integer until, String geohash) {
        Date now = new Date(System.currentTimeMillis());
        Date start = CalculateDateExtensions.substractYearsFromDate((Date)now, (int)until);
        Date end = CalculateDateExtensions.substractYearsFromDate((Date)now, (int)from);
        StringBuilder hqlString = new StringBuilder();
        hqlString.append("select ud from UserDatas ud where ud.gender=:gender and ud.dateofbirth >= :start and ud.dateofbirth <= :end ");
        Map adjacentAreas = null;
        if (geohash != null && !geohash.trim().isEmpty()) {
            adjacentAreas = GeoHashExtensions.getTwentyFiveAreasMap((String)geohash);
        }
        if (adjacentAreas != null) {
            String firstAndSecondRingSubQuery = HqlStringCreator.getGeohashFirstAndSecondRingSubQuery();
            hqlString.append("and ud.primaryAddress.geohash in " + firstAndSecondRingSubQuery);
        }
        String queryString = hqlString.toString();
        LOGGER.info((Object)("Query String from method findUsers:" + queryString));
        Query query = this.getQuery(queryString);
        query.setParameter("gender", (Object)searchGender);
        query.setParameter("start", (Object)start);
        query.setParameter("end", (Object)end);
        if (adjacentAreas != null) {
            for (Map.Entry entry : adjacentAreas.entrySet()) {
                query.setParameter((String)entry.getKey(), (Object)((String)entry.getValue() + "%"));
            }
        }
        List userDatas = query.getResultList();
        return userDatas;
    }

    @Autowired
    public void setUserDataDao(UserDatasDao userDataDao) {
        this.setDao((EntityManagerDao)userDataDao);
    }
}

