/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.daos.RecommendationsDao;
import de.alpharogroup.user.management.entities.Recommendations;
import de.alpharogroup.user.management.service.api.RecommendationsService;
import de.alpharogroup.user.management.service.util.HqlStringCreator;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="recommendationsService")
public class RecommendationsBusinessService
extends AbstractBusinessService<Recommendations, Integer, RecommendationsDao>
implements RecommendationsService {
    private static final long serialVersionUID = 1L;

    @Override
    public List<Recommendations> find(Users user, Users recommended, String email) {
        String hqlString = HqlStringCreator.forRecommendations(user, recommended, email);
        Query query = this.getQuery(hqlString);
        if (user != null) {
            query.setParameter("user", (Object)user);
        }
        if (recommended != null) {
            query.setParameter("recommended", (Object)recommended);
        }
        if (email != null) {
            query.setParameter("email", (Object)email);
        }
        List recommendations = query.getResultList();
        return recommendations;
    }

    @Override
    public Recommendations findRecommendations(Users user, Users recommended, String email) {
        return (Recommendations)ListExtensions.getFirst(this.find(user, recommended, email));
    }

    @Autowired
    public void setRecommendationsDao(RecommendationsDao recommendationsDao) {
        this.setDao((EntityManagerDao)recommendationsDao);
    }
}

