/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.management.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.management.daos.ContactmethodsDao;
import de.alpharogroup.user.management.entities.Contactmethods;
import de.alpharogroup.user.management.enums.ContactmethodType;
import de.alpharogroup.user.management.service.api.ContactmethodsService;
import de.alpharogroup.user.management.service.util.HqlStringCreator;
import java.util.List;
import javax.persistence.Query;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="contactmethodsService")
public class ContactmethodsBusinessService
extends AbstractBusinessService<Contactmethods, Integer, ContactmethodsDao>
implements ContactmethodsService {
    private static final long serialVersionUID = 1L;

    @Override
    public boolean compare(Contactmethods contact, Contactmethods compare) {
        if (contact == null && compare != null) {
            return false;
        }
        if (contact == null && compare == null) {
            return true;
        }
        if (contact != null && compare == null) {
            return false;
        }
        if (contact.getContactvalue() == null && compare.getContactvalue() != null) {
            return false;
        }
        if (contact.getContactvalue() == null && compare.getContactvalue() == null) {
            return true;
        }
        if (contact.getContactvalue() != null && compare.getContactvalue() == null) {
            return false;
        }
        return contact.getContactmethod().equals((Object)compare.getContactmethod()) && contact.getContactvalue().equals(compare.getContactvalue());
    }

    @Override
    public boolean existsContact(Contactmethods contact) {
        return this.existsContact(contact.getContactvalue(), contact.getContactmethod());
    }

    @Override
    public boolean existsContact(String contactValue, ContactmethodType contactMethod) {
        List<Contactmethods> contacts = this.findContact(contactValue, contactMethod);
        return null != contacts && !contacts.isEmpty();
    }

    @Override
    public List<Contactmethods> find(ContactmethodType contactmethod, String contactvalue) {
        String hqlString = HqlStringCreator.forContactmethods(contactmethod, contactvalue);
        Query query = this.getQuery(hqlString);
        if (contactmethod != null) {
            query.setParameter("contactmethod", (Object)contactmethod);
        }
        if (contactvalue != null) {
            query.setParameter("contactvalue", (Object)contactvalue);
        }
        List contactmethods = query.getResultList();
        return contactmethods;
    }

    @Override
    public List<Contactmethods> findContact(String contactValue, ContactmethodType contactMethod) {
        return this.find(contactMethod, contactValue);
    }

    @Override
    public List<Contactmethods> findContactmethod(ContactmethodType contactmethod, Users user) {
        String hqlString = "select distinct cm from UserDatas u inner join u.contactmethods cm where u.owner=:user and cm.contactmethod.contactmethod=:contactmethod";
        Query query = this.getQuery("select distinct cm from UserDatas u inner join u.contactmethods cm where u.owner=:user and cm.contactmethod.contactmethod=:contactmethod");
        if (user != null) {
            query.setParameter("user", (Object)user);
        }
        if (contactmethod != null) {
            query.setParameter("contactmethod", (Object)contactmethod);
        }
        List contactmethods = query.getResultList();
        return contactmethods;
    }

    @Autowired
    public void setContactmethodsDao(ContactmethodsDao repository) {
        this.setDao((EntityManagerDao)repository);
    }
}

