/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.factories;

import de.alpharogroup.user.entities.Permissions;
import de.alpharogroup.user.entities.RelationPermissions;
import de.alpharogroup.user.entities.ResetPasswords;
import de.alpharogroup.user.entities.Roles;
import de.alpharogroup.user.entities.Users;
import java.io.Serializable;
import java.util.Date;
import java.util.HashSet;
import java.util.Set;

public class UserManagementFactory
implements Serializable {
    private static final UserManagementFactory instance = new UserManagementFactory();
    private static final long serialVersionUID = 1L;

    public static UserManagementFactory getInstance() {
        return instance;
    }

    private UserManagementFactory() {
    }

    public Permissions newPermissions(Integer id, String permission, String description, String shortcut) {
        Permissions permissions = new Permissions();
        permissions.setDescription(description);
        permissions.setId(id);
        permissions.setPermissionName(permission);
        permissions.setShortcut(shortcut);
        return permissions;
    }

    public Permissions newPermissions(String permission, String description) {
        return this.newPermissions(null, permission, description, null);
    }

    public Permissions newPermissions(String permission, String description, String shortcut) {
        return this.newPermissions(null, permission, description, shortcut);
    }

    public RelationPermissions newRelationPermissions(Integer id, Users provider, Users subscriber, Set<Permissions> permissions) {
        RelationPermissions relationPermissions = new RelationPermissions();
        relationPermissions.setId(id);
        relationPermissions.setProvider(provider);
        relationPermissions.setSubscriber(subscriber);
        relationPermissions.setPermissions(permissions);
        return relationPermissions;
    }

    public RelationPermissions newRelationPermissions(Users provider, Users subscriber) {
        return this.newRelationPermissions(provider, subscriber, new HashSet<Permissions>());
    }

    public RelationPermissions newRelationPermissions(Users provider, Users subscriber, Set<Permissions> permissions) {
        return this.newRelationPermissions(null, provider, subscriber, permissions);
    }

    public ResetPasswords newResetPasswords(Date expiryDate, String generatedPassword, Date starttime, Users user) {
        return this.newResetPasswords(null, expiryDate, generatedPassword, starttime, user);
    }

    public ResetPasswords newResetPasswords(Integer id, Date expiryDate, String generatedPassword, Date starttime, Users user) {
        ResetPasswords resetPasswords = new ResetPasswords();
        resetPasswords.setExpiryDate(expiryDate);
        resetPasswords.setGeneratedPassword(generatedPassword);
        resetPasswords.setId(id);
        resetPasswords.setStarttime(starttime);
        resetPasswords.setUser(user);
        return resetPasswords;
    }

    public Roles newRoles(Integer id, String rolename, String description, Set<Permissions> permissions) {
        Roles roles = new Roles();
        roles.setDescription(description);
        roles.setId(id);
        roles.setRolename(rolename);
        if (permissions != null) {
            roles.setPermissions(permissions);
        }
        return roles;
    }

    public Roles newRoles(String rolename, String description) {
        return this.newRoles(rolename, description, null);
    }

    public Roles newRoles(String rolename, String description, Set<Permissions> permissions) {
        return this.newRoles(null, rolename, description, permissions);
    }

    public Users newUsers(Boolean active, String pw, String salt, String username, Boolean locked, Set<Roles> roles) {
        return this.newUsers(null, active, pw, salt, username, locked, roles);
    }

    public Users newUsers(Integer id, Boolean active, String pw, String salt, String username, Boolean locked, Set<Roles> roles) {
        Users users = new Users();
        users.setActive(active);
        users.setLocked(locked);
        users.setId(id);
        users.setPw(pw);
        users.setSalt(salt);
        users.setUsername(username);
        if (roles != null) {
            users.setRoles(roles);
        }
        return users;
    }
}

