/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.service.domain.AbstractDomainService;
import de.alpharogroup.user.domain.Role;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.entities.Roles;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.mapper.UsersMapper;
import de.alpharogroup.user.repositories.UsersDao;
import de.alpharogroup.user.service.api.BaseUserService;
import de.alpharogroup.user.service.api.BaseUsersService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="baseUserDomainService")
public class BaseUserDomainService
extends AbstractDomainService<Integer, User, Users, UsersDao, UsersMapper>
implements BaseUserService {
    @Autowired
    private BaseUsersService usersService;

    @Override
    public boolean existsUserWithUsername(String username) {
        return this.usersService.existsUserWithUsername(username);
    }

    @Override
    public List<Role> findRolesFromUser(User user) {
        Users users = (Users)((UsersMapper)this.getMapper()).toEntity((DomainObject)user);
        List roles = this.usersService.findRolesFromUser(users);
        List roless = ((UsersMapper)this.getMapper()).map(roles, Role.class);
        return roless;
    }

    @Override
    public User findUserWithUsername(String username) {
        Users users = this.usersService.findUserWithUsername(username);
        User user = (User)((UsersMapper)this.getMapper()).toDomainObject((BaseEntity)users);
        return user;
    }

    @Autowired
    public void setUsersDao(UsersDao usersDao) {
        this.setDao((EntityManagerDao)usersDao);
    }

    @Autowired
    public void setUsersMapper(UsersMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    @Override
    public boolean userIsInRole(User user, Role role) {
        Users users = (Users)((UsersMapper)this.getMapper()).toEntity((DomainObject)user);
        Roles roles = (Roles)((UsersMapper)this.getMapper()).map((Object)role, Roles.class);
        return this.usersService.userIsInRole(users, roles);
    }

    public BaseUsersService getUsersService() {
        return this.usersService;
    }

    public void setUsersService(BaseUsersService usersService) {
        this.usersService = usersService;
    }
}

