/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.service;

import de.alpharogroup.auth.models.AuthenticationErrors;
import de.alpharogroup.auth.models.AuthenticationResult;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.mapper.UsersMapper;
import de.alpharogroup.user.service.api.BaseAuthenticationService;
import de.alpharogroup.user.service.api.BaseAuthenticationsService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="baseAuthenticationDomainService")
public class BaseAuthenticationDomainService
implements BaseAuthenticationService {
    @Autowired
    private BaseAuthenticationsService baseAuthenticationsService;
    private final UsersMapper mapper = new UsersMapper();

    @Override
    public AuthenticationResult<User, AuthenticationErrors> authenticate(String emailOrUsername, String password) {
        AuthenticationResult originalAuthenticationResult = this.baseAuthenticationsService.authenticate(emailOrUsername, password);
        AuthenticationResult authenticationResult = AuthenticationResult.builder().validationErrors(originalAuthenticationResult.getValidationErrors()).user((Object)this.mapper.toDomainObject((BaseEntity)originalAuthenticationResult.getUser())).build();
        return authenticationResult;
    }

    @Override
    public String newAuthenticationToken(String username) {
        return this.baseAuthenticationsService.newAuthenticationToken(username);
    }

    public BaseAuthenticationsService getBaseAuthenticationsService() {
        return this.baseAuthenticationsService;
    }

    public void setBaseAuthenticationsService(BaseAuthenticationsService baseAuthenticationsService) {
        this.baseAuthenticationsService = baseAuthenticationsService;
    }
}

