/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.domain;

import de.alpharogroup.domain.BaseDomainObject;
import de.alpharogroup.user.domain.Role;
import java.beans.ConstructorProperties;
import java.util.HashSet;
import java.util.Set;

public class User
extends BaseDomainObject<Integer> {
    private static final long serialVersionUID = 1L;
    private Boolean active;
    private Boolean locked;
    private String pw;
    private Set<Role> roles;
    private String salt;
    private String username;

    private static Set<Role> $default$roles() {
        return new HashSet<Role>();
    }

    public static UserBuilder builder() {
        return new UserBuilder();
    }

    public Boolean getActive() {
        return this.active;
    }

    public Boolean getLocked() {
        return this.locked;
    }

    public String getPw() {
        return this.pw;
    }

    public Set<Role> getRoles() {
        return this.roles;
    }

    public String getSalt() {
        return this.salt;
    }

    public String getUsername() {
        return this.username;
    }

    public void setActive(Boolean active) {
        this.active = active;
    }

    public void setLocked(Boolean locked) {
        this.locked = locked;
    }

    public void setPw(String pw) {
        this.pw = pw;
    }

    public void setRoles(Set<Role> roles) {
        this.roles = roles;
    }

    public void setSalt(String salt) {
        this.salt = salt;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String toString() {
        return "User(super=" + super.toString() + ", active=" + this.getActive() + ", locked=" + this.getLocked() + ", pw=" + this.getPw() + ", roles=" + this.getRoles() + ", salt=" + this.getSalt() + ", username=" + this.getUsername() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof User)) {
            return false;
        }
        User other = (User)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        Boolean this$active = this.getActive();
        Boolean other$active = other.getActive();
        if (this$active == null ? other$active != null : !((Object)this$active).equals(other$active)) {
            return false;
        }
        Boolean this$locked = this.getLocked();
        Boolean other$locked = other.getLocked();
        if (this$locked == null ? other$locked != null : !((Object)this$locked).equals(other$locked)) {
            return false;
        }
        String this$pw = this.getPw();
        String other$pw = other.getPw();
        if (this$pw == null ? other$pw != null : !this$pw.equals(other$pw)) {
            return false;
        }
        Set<Role> this$roles = this.getRoles();
        Set<Role> other$roles = other.getRoles();
        if (this$roles == null ? other$roles != null : !((Object)this$roles).equals(other$roles)) {
            return false;
        }
        String this$salt = this.getSalt();
        String other$salt = other.getSalt();
        if (this$salt == null ? other$salt != null : !this$salt.equals(other$salt)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        return !(this$username == null ? other$username != null : !this$username.equals(other$username));
    }

    protected boolean canEqual(Object other) {
        return other instanceof User;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + super.hashCode();
        Boolean $active = this.getActive();
        result = result * 59 + ($active == null ? 43 : ((Object)$active).hashCode());
        Boolean $locked = this.getLocked();
        result = result * 59 + ($locked == null ? 43 : ((Object)$locked).hashCode());
        String $pw = this.getPw();
        result = result * 59 + ($pw == null ? 43 : $pw.hashCode());
        Set<Role> $roles = this.getRoles();
        result = result * 59 + ($roles == null ? 43 : ((Object)$roles).hashCode());
        String $salt = this.getSalt();
        result = result * 59 + ($salt == null ? 43 : $salt.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        return result;
    }

    public User() {
    }

    @ConstructorProperties(value={"active", "locked", "pw", "roles", "salt", "username"})
    public User(Boolean active, Boolean locked, String pw, Set<Role> roles, String salt, String username) {
        this.active = active;
        this.locked = locked;
        this.pw = pw;
        this.roles = roles;
        this.salt = salt;
        this.username = username;
    }

    public static class UserBuilder {
        private Boolean active;
        private Boolean locked;
        private String pw;
        private boolean roles$set;
        private Set<Role> roles;
        private String salt;
        private String username;

        UserBuilder() {
        }

        public UserBuilder active(Boolean active) {
            this.active = active;
            return this;
        }

        public UserBuilder locked(Boolean locked) {
            this.locked = locked;
            return this;
        }

        public UserBuilder pw(String pw) {
            this.pw = pw;
            return this;
        }

        public UserBuilder roles(Set<Role> roles) {
            this.roles = roles;
            this.roles$set = true;
            return this;
        }

        public UserBuilder salt(String salt) {
            this.salt = salt;
            return this;
        }

        public UserBuilder username(String username) {
            this.username = username;
            return this;
        }

        public User build() {
            return new User(this.active, this.locked, this.pw, this.roles$set ? this.roles : User.$default$roles(), this.salt, this.username);
        }

        public String toString() {
            return "User.UserBuilder(active=" + this.active + ", locked=" + this.locked + ", pw=" + this.pw + ", roles=" + this.roles + ", salt=" + this.salt + ", username=" + this.username + ")";
        }
    }
}

