/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.domain.DomainObject;
import de.alpharogroup.service.domain.AbstractDomainService;
import de.alpharogroup.user.domain.Permission;
import de.alpharogroup.user.domain.Role;
import de.alpharogroup.user.entities.Permissions;
import de.alpharogroup.user.entities.Roles;
import de.alpharogroup.user.mapper.RolesMapper;
import de.alpharogroup.user.repositories.RolesDao;
import de.alpharogroup.user.service.api.RoleService;
import de.alpharogroup.user.service.api.RolesService;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="roleDomainService")
public class RoleDomainService
extends AbstractDomainService<Integer, Role, Roles, RolesDao, RolesMapper>
implements RoleService {
    @Autowired
    private RolesService rolesService;

    @Autowired
    public void setRolesDao(RolesDao rolesDao) {
        this.setDao((EntityManagerDao)rolesDao);
    }

    @Autowired
    public void setRolesMapper(RolesMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    @Override
    public List<Permission> findAllPermissions(Role role) {
        Roles roles = (Roles)((RolesMapper)this.getMapper()).toEntity((DomainObject)role);
        List permissions = this.rolesService.findAllPermissions(roles);
        List perms = ((RolesMapper)this.getMapper()).map(permissions, Permission.class);
        return perms;
    }

    @Override
    public Role findRole(String rolename) {
        return (Role)((RolesMapper)this.getMapper()).toDomainObject((BaseEntity)this.rolesService.findRole(rolename));
    }

    @Override
    public List<Role> findRoles(String rolename) {
        return ((RolesMapper)this.getMapper()).toDomainObjects(this.rolesService.findRoles(rolename));
    }

    @Override
    public boolean exists(String rolename) {
        return this.rolesService.exists(rolename);
    }

    @Override
    public Role createAndSaveRole(String rolename, String description) {
        return (Role)((RolesMapper)this.getMapper()).toDomainObject((BaseEntity)this.rolesService.createAndSaveRole(rolename, description));
    }

    @Override
    public Role createAndSaveRole(String rolename, String description, Set<Permission> permissions) {
        List perms = ((RolesMapper)this.getMapper()).map(permissions, Permissions.class);
        Roles roles = this.rolesService.createAndSaveRole(rolename, description, new HashSet(perms));
        return (Role)((RolesMapper)this.getMapper()).toDomainObject((BaseEntity)roles);
    }

    public RolesService getRolesService() {
        return this.rolesService;
    }

    public void setRolesService(RolesService rolesService) {
        this.rolesService = rolesService;
    }
}

