/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.service.domain.AbstractDomainService;
import de.alpharogroup.user.domain.Permission;
import de.alpharogroup.user.domain.RelationPermission;
import de.alpharogroup.user.domain.User;
import de.alpharogroup.user.entities.Permissions;
import de.alpharogroup.user.entities.RelationPermissions;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.mapper.RelationPermissionsMapper;
import de.alpharogroup.user.repositories.RelationPermissionsDao;
import de.alpharogroup.user.service.api.RelationPermissionService;
import de.alpharogroup.user.service.api.RelationPermissionsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="relationPermissionDomainService")
public class RelationPermissionDomainService
extends AbstractDomainService<Integer, RelationPermission, RelationPermissions, RelationPermissionsDao, RelationPermissionsMapper>
implements RelationPermissionService {
    @Autowired
    private RelationPermissionsService relationPermissionsService;

    @Autowired
    public void setRelationPermissionsDao(RelationPermissionsDao relationPermissionsDao) {
        this.setDao((EntityManagerDao)relationPermissionsDao);
    }

    @Autowired
    public void setRelationPermissionsMapper(RelationPermissionsMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    @Override
    public RelationPermission findRelationPermissions(User provider, User subscriber) {
        Users providers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)provider, Users.class);
        Users subscribers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)subscriber, Users.class);
        RelationPermission relationPermission = (RelationPermission)((RelationPermissionsMapper)this.getMapper()).toDomainObject((BaseEntity)this.relationPermissionsService.findRelationPermissions(providers, subscribers));
        return relationPermission;
    }

    @Override
    public RelationPermission findRelationPermissions(User provider, User subscriber, Permission permission) {
        Users providers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)provider, Users.class);
        Users subscribers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)subscriber, Users.class);
        Permissions permissions = (Permissions)((RelationPermissionsMapper)this.getMapper()).map((Object)permission, Permissions.class);
        RelationPermission relationPermission = (RelationPermission)((RelationPermissionsMapper)this.getMapper()).toDomainObject((BaseEntity)this.relationPermissionsService.findRelationPermissions(providers, subscribers, permissions));
        return relationPermission;
    }

    @Override
    public List<RelationPermission> find(User provider, User subscriber) {
        Users providers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)provider, Users.class);
        Users subscribers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)subscriber, Users.class);
        List relationPermissions = ((RelationPermissionsMapper)this.getMapper()).toDomainObjects(this.relationPermissionsService.find(providers, subscribers));
        return relationPermissions;
    }

    @Override
    public List<RelationPermission> find(User provider, User subscriber, Permission permission) {
        Users providers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)provider, Users.class);
        Users subscribers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)subscriber, Users.class);
        Permissions permissions = (Permissions)((RelationPermissionsMapper)this.getMapper()).map((Object)permission, Permissions.class);
        List relationPermissions = ((RelationPermissionsMapper)this.getMapper()).toDomainObjects(this.relationPermissionsService.find(providers, subscribers, permissions));
        return relationPermissions;
    }

    @Override
    public void addPermission(User provider, User subscriber, Permission permission) {
        Users providers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)provider, Users.class);
        Users subscribers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)subscriber, Users.class);
        Permissions permissions = (Permissions)((RelationPermissionsMapper)this.getMapper()).map((Object)permission, Permissions.class);
        this.relationPermissionsService.addPermission(providers, subscribers, permissions);
    }

    @Override
    public void removePermission(User provider, User subscriber, Permission permission) {
        Users providers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)provider, Users.class);
        Users subscribers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)subscriber, Users.class);
        Permissions permissions = (Permissions)((RelationPermissionsMapper)this.getMapper()).map((Object)permission, Permissions.class);
        this.relationPermissionsService.removePermission(providers, subscribers, permissions);
    }

    @Override
    public void removeAllPermissions(User provider, User subscriber) {
        Users providers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)provider, Users.class);
        Users subscribers = (Users)((RelationPermissionsMapper)this.getMapper()).map((Object)subscriber, Users.class);
        this.relationPermissionsService.removeAllPermissions(providers, subscribers);
    }

    public RelationPermissionsService getRelationPermissionsService() {
        return this.relationPermissionsService;
    }

    public void setRelationPermissionsService(RelationPermissionsService relationPermissionsService) {
        this.relationPermissionsService = relationPermissionsService;
    }
}

