/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.service;

import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.entitymapper.EntityDOMapper;
import de.alpharogroup.service.domain.AbstractDomainService;
import de.alpharogroup.user.domain.Permission;
import de.alpharogroup.user.entities.Permissions;
import de.alpharogroup.user.mapper.PermissionsMapper;
import de.alpharogroup.user.repositories.PermissionsDao;
import de.alpharogroup.user.service.api.PermissionService;
import de.alpharogroup.user.service.api.PermissionsService;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="permissionDomainService")
public class PermissionDomainService
extends AbstractDomainService<Integer, Permission, Permissions, PermissionsDao, PermissionsMapper>
implements PermissionService {
    @Autowired
    private PermissionsService permissionsService;

    @Autowired
    public void setPermissionsDao(PermissionsDao permissionsDao) {
        this.setDao((EntityManagerDao)permissionsDao);
    }

    @Autowired
    public void setPermissionsMapper(PermissionsMapper mapper) {
        this.setMapper((EntityDOMapper)mapper);
    }

    @Override
    public Permission createAndSavePermissions(String name, String description) {
        return (Permission)((PermissionsMapper)this.getMapper()).toDomainObject((BaseEntity)this.permissionsService.createAndSavePermissions(name, description));
    }

    @Override
    public Permission createAndSavePermissions(String name, String description, String shortcut) {
        return (Permission)((PermissionsMapper)this.getMapper()).toDomainObject((BaseEntity)this.permissionsService.createAndSavePermissions(name, description, shortcut));
    }

    @Override
    public Permission findByShortcut(String shortcut) {
        return (Permission)((PermissionsMapper)this.getMapper()).toDomainObject((BaseEntity)this.permissionsService.findByShortcut(shortcut));
    }

    @Override
    public Permission findByName(String name) {
        return (Permission)((PermissionsMapper)this.getMapper()).toDomainObject((BaseEntity)this.permissionsService.findByName(name));
    }

    @Override
    public List<Permission> find(String description, String permissionName, String shortcut) {
        return ((PermissionsMapper)this.getMapper()).toDomainObjects(this.permissionsService.find(description, permissionName, shortcut));
    }

    public PermissionsService getPermissionsService() {
        return this.permissionsService;
    }

    public void setPermissionsService(PermissionsService permissionsService) {
        this.permissionsService = permissionsService;
    }
}

