/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.entity.BaseEntity;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.random.RandomExtensions;
import de.alpharogroup.user.entities.UserTokens;
import de.alpharogroup.user.repositories.UserTokensDao;
import de.alpharogroup.user.service.api.UserTokensService;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.apache.commons.collections4.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.torpedoquery.jpa.Query;
import org.torpedoquery.jpa.Torpedo;

@Transactional
@Service(value="userTokensService")
public class UserTokensBusinessService
extends AbstractBusinessService<UserTokens, Integer, UserTokensDao>
implements UserTokensService {
    private static final long serialVersionUID = 1L;

    @Override
    public UserTokens find(String username) {
        return (UserTokens)ListExtensions.getFirst(this.findAll(username));
    }

    @Override
    public List<UserTokens> findAll(String username) {
        List userTokens = null;
        UserTokens from = (UserTokens)Torpedo.from(UserTokens.class);
        Torpedo.where((String)from.getUsername()).eq((Object)username);
        Query select = Torpedo.select((Object)from);
        userTokens = select.list(((UserTokensDao)this.getDao()).getEntityManager());
        return userTokens;
    }

    @Override
    public String getAutheticationToken(String username) {
        UserTokens token = this.find(username);
        if (token != null) {
            return token.getToken();
        }
        return null;
    }

    @Override
    public boolean isValid(String token) {
        List userTokens = null;
        UserTokens from = (UserTokens)Torpedo.from(UserTokens.class);
        Torpedo.where((String)from.getToken()).eq((Object)token);
        Query select = Torpedo.select((Object)from);
        userTokens = select.list(((UserTokensDao)this.getDao()).getEntityManager());
        boolean valid = CollectionUtils.isNotEmpty((Collection)userTokens);
        return valid;
    }

    @Override
    public String newAuthenticationToken(String username) {
        UserTokens userTokens = this.find(username);
        if (userTokens == null) {
            userTokens = (UserTokens)this.merge((BaseEntity)this.newUserTokens(username));
        }
        Date now = Date.from(LocalDateTime.now().atZone(ZoneId.systemDefault()).toInstant());
        if (userTokens.getExpiry().before(now)) {
            Date expiry = Date.from(LocalDateTime.now().plusMonths(12L).atZone(ZoneId.systemDefault()).toInstant());
            String token = RandomExtensions.randomToken();
            userTokens.setExpiry(expiry);
            userTokens.setToken(token);
            userTokens = (UserTokens)this.merge((BaseEntity)userTokens);
        }
        return userTokens.getToken();
    }

    private UserTokens newUserTokens(String username) {
        Date expiry = Date.from(LocalDateTime.now().plusMonths(12L).atZone(ZoneId.systemDefault()).toInstant());
        String token = RandomExtensions.randomToken();
        UserTokens userTokens = UserTokens.builder().expiry(expiry).username(username).token(token).build();
        return userTokens;
    }

    @Autowired
    public void setUserTokensDao(UserTokensDao userTokensDao) {
        this.setDao((EntityManagerDao)userTokensDao);
    }
}

