/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.user.service;

import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.db.dao.jpa.EntityManagerDao;
import de.alpharogroup.db.service.jpa.AbstractBusinessService;
import de.alpharogroup.user.entities.Roles;
import de.alpharogroup.user.entities.Users;
import de.alpharogroup.user.repositories.UsersDao;
import de.alpharogroup.user.service.api.BaseUsersService;
import java.util.List;
import javax.persistence.Query;
import org.apache.log4j.Logger;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Transactional
@Service(value="baseUsersService")
public class BaseUserBusinessService
extends AbstractBusinessService<Users, Integer, UsersDao>
implements BaseUsersService {
    protected static final Logger LOGGER = Logger.getLogger((String)BaseUserBusinessService.class.getName());
    private static final long serialVersionUID = 1L;

    @Override
    public boolean existsUserWithUsername(String username) {
        Users users = this.findUserWithUsername(username);
        return users != null;
    }

    @Override
    public List<Roles> findRolesFromUser(Users user) {
        String hqlString = "select u.roles from Users u where u=:user";
        Query query = this.getQuery("select u.roles from Users u where u=:user");
        query.setParameter("user", (Object)user);
        List roles = query.getResultList();
        return roles;
    }

    @Override
    public Users findUserWithUsername(String username) {
        String hqlString = "select u from Users u where u.username=:username";
        Query query = this.getQuery("select u from Users u where u.username=:username");
        query.setParameter("username", (Object)username);
        List users = query.getResultList();
        return (Users)ListExtensions.getFirst((List)users);
    }

    @Autowired
    public void setUsersDao(UsersDao usersDao) {
        this.setDao((EntityManagerDao)usersDao);
    }

    @Override
    public boolean userIsInRole(Users user, Roles role) {
        List<Roles> roles = this.findRolesFromUser(user);
        return null != roles && !roles.isEmpty() && roles.contains(role);
    }
}

