/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.util.resource.loader;

import db.resource.bundles.application.DatabaseControl;
import java.util.Locale;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.apache.wicket.Application;
import org.apache.wicket.Component;
import org.apache.wicket.Session;
import org.apache.wicket.WicketRuntimeException;
import org.apache.wicket.resource.loader.IStringResourceLoader;

public class DatabaseResourceLoader
implements IStringResourceLoader {
    private String bundleName;

    public DatabaseResourceLoader(String resourceBundleName) {
        this.bundleName = resourceBundleName;
    }

    private String findResource(Locale locale, String key) {
        ResourceBundle resourceBundle;
        String string;
        block7: {
            string = null;
            if (locale == null) {
                locale = Session.exists() ? Session.get().getLocale() : Locale.getDefault();
            }
            resourceBundle = null;
            try {
                resourceBundle = ResourceBundle.getBundle(this.bundleName, locale, (ResourceBundle.Control)new DatabaseControl());
            }
            catch (MissingResourceException e) {
                if (!this.shouldThrowExceptionForMissingResource()) break block7;
                throw new WicketRuntimeException(String.format("Unable able to locate resource bundle for the specifed base name: %s", this.bundleName));
            }
        }
        if (resourceBundle != null) {
            boolean caught = false;
            try {
                string = resourceBundle.getString(key);
            }
            catch (MissingResourceException e) {
                caught = true;
            }
            if ((caught || string == null) && this.shouldThrowExceptionForMissingResource()) {
                throw new WicketRuntimeException(String.format("Unable able to locate resource bundle for the specifed base name: %s", this.bundleName));
            }
        }
        return string;
    }

    private boolean shouldThrowExceptionForMissingResource() {
        return Application.get().getResourceSettings().getThrowExceptionOnMissingResource();
    }

    public String loadStringResource(Class<?> clazz, String key, Locale locale, String style, String variation) {
        return this.findResource(locale, key);
    }

    public String loadStringResource(Component component, String key, Locale locale, String style, String variation) {
        return this.findResource(component.getLocale(), key);
    }
}

