/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.sign.up.search;

import address.book.application.model.LocationModel;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.sign.up.SignUpModel;
import de.alpharogroup.wicket.components.sign.up.search.LocationPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public abstract class SearchLocationFormPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final AjaxButton submitButton;
    private final Label buttonLabel;
    private final LocationPanel locationPanel;
    private final Form<SignUpModel> form;

    public LocationPanel getLocationPanel() {
        return this.locationPanel;
    }

    public SearchLocationFormPanel(String id, IModel<LocationModel> model) {
        super(id);
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form");
        componentArray[0] = this.form;
        this.add(componentArray);
        this.form.setOutputMarkupId(true);
        this.locationPanel = this.newLocationPanel("locationPanel", model);
        this.form.add(new Component[]{this.locationPanel});
        this.submitButton = this.newButton("submitButton", model);
        this.buttonLabel = this.newButtonLabel("buttonLabel", this.newButtonResourceKey(), "Ausw\u00e4hlen", (Component)this);
        this.submitButton.add(new Component[]{this.buttonLabel});
        this.form.add(new Component[]{this.submitButton});
    }

    protected abstract LocationPanel newLocationPanel(String var1, IModel<? extends LocationModel> var2);

    protected AjaxButton newButton(String id, final IModel<LocationModel> model) {
        return new IndicatingAjaxButton(id, this.form){
            private static final long serialVersionUID = 1L;

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
                LocationModel object = (LocationModel)model.getObject();
                String countryName = (String)SearchLocationFormPanel.this.locationPanel.getDropDownChoiceTextFieldPanel().getStringTwoDropDownChoicesModel().getSelectedRootOption();
                object.setSelectedCountryName(countryName);
                String location = SearchLocationFormPanel.this.locationPanel.getDropDownChoiceTextFieldPanel().getZipcode().getDefaultModelObjectAsString();
                object.setLocation(location);
                SearchLocationFormPanel.this.onSearch(target, (LocationModel)model.getObject());
            }

            protected void onError(AjaxRequestTarget target, Form<?> form) {
            }
        };
    }

    protected Form<SignUpModel> newForm(String id) {
        Form form = new Form(id);
        form.setOutputMarkupId(true);
        return form;
    }

    protected Label newButtonLabel(String id, String resourceKey, String defaultValue, Component component) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)resourceKey, (Component)component, (String)defaultValue);
        Label label = new Label(id, labelModel);
        label.setOutputMarkupId(true);
        return label;
    }

    protected String newButtonResourceKey() {
        return "global.choose.label";
    }

    public AjaxButton getSubmitButton() {
        return this.submitButton;
    }

    public abstract void onSearch(AjaxRequestTarget var1, LocationModel var2);
}

