/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.inbox.send.response;

import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.labeled.label.LabeledEnumLabelPanel;
import de.alpharogroup.wicket.components.labeled.textarea.LabeledTextAreaPanel;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledTextFieldPanel;
import java.io.Serializable;
import message.system.application.models.ReplyMessageModel;
import message.system.application.models.utlis.MessageModelConverter;
import message.system.model.Messages;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class AbstractSendResponseMessagePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected final Form<ReplyMessageModel> form;
    protected final Button inboxButton;
    protected final Button upperSendButton;
    protected Component sender;
    protected Component subject;
    protected LabeledTextAreaPanel<ReplyMessageModel> messageContent;
    protected final Button lowerSendButton;
    protected final Label replyMessageLabel;

    public AbstractSendResponseMessagePanel(String id, PageParameters parameters) {
        super(id);
        Messages message = this.onGetMessage(parameters);
        ReplyMessageModel model = MessageModelConverter.convert((Messages)message);
        this.setDefaultModel((IModel)Model.of((Serializable)model));
        String responseSubjectPart = "RE:";
        if (model.getMessageContentModel().getSubject() != null) {
            responseSubjectPart = responseSubjectPart + model.getMessageContentModel().getSubject();
        }
        model.setResponseSubject(responseSubjectPart);
        CompoundPropertyModel cpm = new CompoundPropertyModel((Object)model);
        this.form = new Form("form", (IModel)cpm);
        this.add(new Component[]{this.form});
        Component[] componentArray = new Component[1];
        this.replyMessageLabel = this.newLabel("replyMessageLabel", this.newReplyMessageLabelModel());
        componentArray[0] = this.replyMessageLabel;
        this.form.add(componentArray);
        this.inboxButton = new Button("inboxButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                AbstractSendResponseMessagePanel.this.onInbox();
            }
        };
        this.form.add(new Component[]{this.inboxButton});
        this.upperSendButton = new Button("upperSendButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                AbstractSendResponseMessagePanel.this.onSend();
            }
        };
        this.form.add(new Component[]{this.upperSendButton});
        this.sender = this.newSenderPanel("sendInformationModel.sender.username", (IModel<ReplyMessageModel>)cpm);
        this.form.add(new Component[]{this.sender});
        this.subject = this.newSubjectPanel("responseSubject", (IModel<ReplyMessageModel>)cpm);
        this.form.add(new Component[]{this.subject});
        StringResourceModel messageContentLabelModel = new StringResourceModel("inbox.message.content.label", (Component)this, null, new Object[0]);
        this.messageContent = new LabeledTextAreaPanel("responseMessage", (IModel)cpm, (IModel)messageContentLabelModel);
        this.form.add(new Component[]{this.messageContent});
        this.lowerSendButton = new Button("lowerSendButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                AbstractSendResponseMessagePanel.this.onSend();
            }
        };
        this.form.add(new Component[]{this.lowerSendButton});
    }

    protected Component newSenderPanel(String id, IModel<ReplyMessageModel> model) {
        LabeledEnumLabelPanel panel = new LabeledEnumLabelPanel(id, model, ResourceModelFactory.newResourceModel((String)"inbox.sender.label", (Component)this));
        return panel;
    }

    protected Component newSubjectPanel(String id, IModel<ReplyMessageModel> model) {
        LabeledTextFieldPanel panel = new LabeledTextFieldPanel(id, model, ResourceModelFactory.newResourceModel((String)"inbox.subject.label", (Component)this));
        return panel;
    }

    protected IModel<String> newReplyMessageLabelModel() {
        return ResourceModelFactory.newResourceModel((String)"inbox.reply.message.header.label", (Component)this);
    }

    protected Label newLabel(String id, IModel<String> model) {
        Label label = new Label(id, model);
        return label;
    }

    protected abstract void onSend();

    protected abstract void onInbox();

    protected abstract Messages onGetMessage(PageParameters var1);
}

