/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.inbox.read;

import de.alpharogroup.wicket.base.BasePanel;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.img.WicketImage;
import de.alpharogroup.wicket.components.labeled.label.LabeledEnumLabelPanel;
import de.alpharogroup.wicket.components.labeled.textarea.LabeledTextAreaPanel;
import java.io.Serializable;
import message.system.model.Messages;
import org.apache.wicket.Component;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class AbstractReadMessagePanel
extends BasePanel {
    private static final long serialVersionUID = 1L;
    protected final Button junkButton;
    protected final Button noJunkButton;
    protected final WicketImage junkmail;
    protected LabeledTextAreaPanel<Messages> messageContent;
    protected final Form<Messages> form;
    protected final Button inboxButton;
    protected final Button deleteButton;
    protected final Component sender;
    protected final Component sentDate;
    protected final Component subject;
    protected final Button replyButton;
    protected final Label readMessageLabel;

    public AbstractReadMessagePanel(String id, PageParameters parameters) {
        super(id);
        Messages message = this.onMessageRead(parameters);
        this.setDefaultModel((IModel)Model.of((Serializable)message));
        CompoundPropertyModel cpm = new CompoundPropertyModel((Object)message);
        this.form = new Form("form", (IModel)cpm);
        this.add(new Component[]{this.form});
        Component[] componentArray = new Component[1];
        this.readMessageLabel = this.newLabel("readMessageLabel", this.newReadMessageLabelModel());
        componentArray[0] = this.readMessageLabel;
        this.form.add(componentArray);
        Model junkImageModel = Model.of((Serializable)((Object)"/images/junkmail.png"));
        this.junkmail = new WicketImage("junkmail", (IModel)junkImageModel);
        this.junkmail.setVisible(message.isSpamFlag());
        this.inboxButton = new Button("inboxButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                AbstractReadMessagePanel.this.onInbox();
            }
        };
        this.form.add(new Component[]{this.inboxButton});
        this.deleteButton = new Button("deleteButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                AbstractReadMessagePanel.this.onDelete();
            }
        };
        this.form.add(new Component[]{this.deleteButton});
        this.junkButton = new Button("junkButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                AbstractReadMessagePanel.this.onJunk();
            }
        };
        this.junkButton.setEnabled(!message.isSpamFlag());
        this.form.add(new Component[]{this.junkButton});
        this.noJunkButton = new Button("noJunkButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                AbstractReadMessagePanel.this.onNoJunk();
            }
        };
        this.noJunkButton.setEnabled(message.isSpamFlag());
        this.form.add(new Component[]{this.noJunkButton});
        this.form.add(new Component[]{this.junkmail});
        this.sender = this.newSenderPanel("sender.username", (IModel<Messages>)cpm);
        this.form.add(new Component[]{this.sender});
        this.sentDate = this.newSentDatePanel("sentDate", (IModel<Messages>)cpm);
        this.form.add(new Component[]{this.sentDate});
        this.subject = this.newSubjectPanel("subject", (IModel<Messages>)cpm);
        this.form.add(new Component[]{this.subject});
        StringResourceModel messageContentLabelModel = new StringResourceModel("inbox.message.content.label", (Component)this, null, new Object[0]);
        this.messageContent = new LabeledTextAreaPanel("messageContent", (IModel)cpm, (IModel)messageContentLabelModel);
        this.messageContent.getTextArea().setEnabled(false);
        this.form.add(new Component[]{this.messageContent});
        this.replyButton = new Button("replyButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                AbstractReadMessagePanel.this.onReply();
            }
        };
        this.form.add(new Component[]{this.replyButton});
    }

    protected Component newSenderPanel(String id, IModel<Messages> model) {
        LabeledEnumLabelPanel panel = new LabeledEnumLabelPanel(id, model, ResourceModelFactory.newResourceModel((String)"inbox.sender.label", (Component)this));
        return panel;
    }

    protected Component newSentDatePanel(String id, IModel<Messages> model) {
        LabeledEnumLabelPanel panel = new LabeledEnumLabelPanel(id, model, ResourceModelFactory.newResourceModel((String)"inbox.sent.date.label", (Component)this));
        return panel;
    }

    protected Component newSubjectPanel(String id, IModel<Messages> model) {
        LabeledEnumLabelPanel panel = new LabeledEnumLabelPanel(id, model, ResourceModelFactory.newResourceModel((String)"inbox.subject.label", (Component)this));
        return panel;
    }

    protected IModel<String> newReadMessageLabelModel() {
        return ResourceModelFactory.newResourceModel((String)"inbox.read.message.header.label", (Component)this);
    }

    protected Label newLabel(String id, IModel<String> model) {
        Label label = new Label(id, model);
        return label;
    }

    protected abstract void onReply();

    protected abstract void onNoJunk();

    protected abstract void onJunk();

    protected abstract void onDelete();

    protected abstract Messages onMessageRead(PageParameters var1);

    protected abstract void onInbox();
}

