/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.address;

import address.book.factories.AddressBookFactory;
import address.book.model.Addresses;
import address.book.model.Federalstates;
import address.book.model.Zipcodes;
import de.alpharogroup.wicket.components.address.AddressModel;
import de.alpharogroup.wicket.components.address.countries.CountriesProvincesPanel;
import de.alpharogroup.wicket.components.i18n.dropdownchoice.renderers.PropertiesChoiceRenderer;
import de.alpharogroup.wicket.model.dropdownchoices.StringTwoDropDownChoicesModel;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.form.RequiredTextField;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.IModel;

public class AddressPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public AddressPanel(String id, IModel<AddressModel> addressModel) {
        super(id, addressModel);
        this.setDefaultModel(addressModel);
        AddressModel modelObject = (AddressModel)addressModel.getObject();
        StringTwoDropDownChoicesModel stringTwoDropDownChoicesModel = modelObject.getCountriesAndProvincesDropDownChoicesModel();
        Addresses address = modelObject.getAddress();
        if (address != null) {
            Federalstates federalState = modelObject.getAddress().getFederalstate();
            if (federalState != null) {
                stringTwoDropDownChoicesModel.setSelectedRootOption((Object)federalState.getCountry().getName());
                stringTwoDropDownChoicesModel.setSelectedChildOption((Object)federalState.getIso3166A2code());
            }
        } else {
            Zipcodes zc = AddressBookFactory.getInstance().newZipcodes(null, "", "");
            Addresses initialAddress = AddressBookFactory.getInstance().newAddresses("", null, null, null, null, "", "", zc);
            modelObject.setAddress(initialAddress);
        }
        RequiredTextField street = new RequiredTextField("address.address.street");
        this.add(new Component[]{street});
        RequiredTextField streetnumber = new RequiredTextField("address.address.streetnumber");
        this.add(new Component[]{streetnumber});
        RequiredTextField zipcode = new RequiredTextField("address.address.zipcode.zipcode");
        this.add(new Component[]{zipcode});
        RequiredTextField city = new RequiredTextField("address.address.zipcode.city");
        this.add(new Component[]{city});
        CountriesProvincesPanel countriesProvincesPanel = this.getCountriesProvincesPanel(stringTwoDropDownChoicesModel);
        this.add(new Component[]{countriesProvincesPanel});
    }

    protected CountriesProvincesPanel getCountriesProvincesPanel(StringTwoDropDownChoicesModel stringTwoDropDownChoicesModel) {
        CountriesProvincesPanel countriesProvincesPanel = new CountriesProvincesPanel("countriesProvincesPanel", stringTwoDropDownChoicesModel, (IChoiceRenderer<String>)new PropertiesChoiceRenderer((Component)this, AddressPanel.class), (IChoiceRenderer<String>)new PropertiesChoiceRenderer((Component)this, AddressPanel.class));
        AttributeModifier samWmcRoot = new AttributeModifier("class", (Serializable)((Object)"countries"));
        AttributeModifier sam = new AttributeModifier("class", (Serializable)((Object)"countries"));
        countriesProvincesPanel.getWmcRootChoice().add(new Behavior[]{samWmcRoot});
        countriesProvincesPanel.getRootChoice().add(new Behavior[]{sam});
        AttributeModifier samWmcChild = new AttributeModifier("class", (Serializable)((Object)"federalstates"));
        countriesProvincesPanel.getWmcChildChoice().add(new Behavior[]{samWmcChild});
        countriesProvincesPanel.getChildChoice().add(new Behavior[]{sam});
        countriesProvincesPanel.getChildChoice().setRequired(true);
        return countriesProvincesPanel;
    }
}

