/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.application;

import de.alpharogroup.date.CreateDateUtils;
import de.alpharogroup.file.checksum.Algorithm;
import de.alpharogroup.file.checksum.ChecksumUtils;
import java.util.List;
import org.apache.commons.lang.ArrayUtils;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.model.util.ListModel;
import resource.system.application.model.ResourcesModel;
import resource.system.application.util.ModelConverter;
import resource.system.model.Resources;

public class WicketModelConverter {
    public static ResourcesModel toResourcesModel(FileUpload upload, ResourcesModel model, String description) {
        model.setContent(ArrayUtils.toObject((byte[])upload.getBytes()));
        model.setContentType(upload.getContentType());
        model.setDescription(description);
        model.setFilename(upload.getClientFileName());
        model.setFilesize(upload.getSize() + "");
        model.setCreated(CreateDateUtils.now());
        model.setChecksum(ChecksumUtils.getChecksumQuietly((byte[])upload.getBytes(), (String)Algorithm.SHA_256.getAlgorithm()));
        model.setDeletedFlag(Boolean.FALSE);
        return model;
    }

    public static ListModel<ResourcesModel> toResourceModelList(List<Resources> resources) {
        return new ListModel(ModelConverter.toResourcesModel(resources));
    }
}

