/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.upload;

import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.upload.UploadFileModel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.form.upload.UploadProgressBar;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.form.upload.FileUploadField;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.util.lang.Bytes;

public abstract class UploadFilePanel
extends GenericPanel<UploadFileModel> {
    private static final long serialVersionUID = 1L;
    private final FileUploadField fileUploadField;
    private final Form<?> form;
    private final Button submitButton;
    private final Label buttonLabel;
    private final Label fileInputLabel;
    private final Bytes maxSize;

    public UploadFilePanel(String id, IModel<UploadFileModel> model) {
        super(id, model);
        this.setOutputMarkupId(true);
        this.maxSize = this.newMaxSize();
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form", model);
        componentArray[0] = this.form;
        this.add(componentArray);
        Component[] componentArray2 = new Component[1];
        this.fileInputLabel = this.newFileInputLabel("fileInputLabel", "upload.file.input.label", "File", (Component)this);
        componentArray2[0] = this.fileInputLabel;
        this.form.add(componentArray2);
        Component[] componentArray3 = new Component[1];
        this.fileUploadField = this.newFileUploadField("fileInput");
        componentArray3[0] = this.fileUploadField;
        this.form.add(componentArray3);
        Component[] componentArray4 = new Component[1];
        this.submitButton = this.newButton("submitButton", this.form);
        componentArray4[0] = this.submitButton;
        this.form.add(componentArray4);
        Component[] componentArray5 = new Component[1];
        this.buttonLabel = this.newButtonLabel("buttonLabel", "upload.file.submit.value.label", "Send", (Component)this);
        componentArray5[0] = this.buttonLabel;
        this.submitButton.add(componentArray5);
    }

    public Label getButtonLabel() {
        return this.buttonLabel;
    }

    public Label getFileInputLabel() {
        return this.fileInputLabel;
    }

    public FileUploadField getFileUploadField() {
        return this.fileUploadField;
    }

    public Form<?> getForm() {
        return this.form;
    }

    public Bytes getMaxSize() {
        return this.maxSize;
    }

    public Button getSubmitButton() {
        return this.submitButton;
    }

    protected Button newButton(String id, Form<?> form) {
        return new IndicatingAjaxButton(id, form){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
                UploadFilePanel.this.onUpload(target, form, true);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
                UploadFilePanel.this.onUpload(target, form, false);
            }
        };
    }

    protected Label newButtonLabel(String id, String resourceKey, String defaultValue, Component component) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)resourceKey, (Component)component, (String)defaultValue);
        Label label = new Label(id, labelModel);
        label.setOutputMarkupId(true);
        return label;
    }

    protected Label newFileInputLabel(String id, String resourceKey, String defaultValue, Component component) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)resourceKey, (Component)component, (String)defaultValue);
        Label label = new Label(id, labelModel);
        label.setOutputMarkupId(true);
        return label;
    }

    protected FileUploadField newFileUploadField(String id) {
        return new FileUploadField(id);
    }

    protected Form<?> newForm(String id, IModel<?> model) {
        Form form = new Form(id, model);
        form.setOutputMarkupId(true);
        form.setMultiPart(true);
        form.setMaxSize(this.getMaxSize());
        return form;
    }

    protected Bytes newMaxSize() {
        return Bytes.kilobytes((long)500L);
    }

    protected UploadProgressBar newUploadProgressBar(String id, Form<?> form, FileUploadField uploadField) {
        return new UploadProgressBar(id, form, uploadField);
    }

    protected abstract void onUpload(AjaxRequestTarget var1, Form<?> var2, boolean var3);
}

