/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.tree.provider;

import de.alpharogroup.event.system.entities.Topics;
import de.alpharogroup.resourcebundle.locale.ResourceBundleExtensions;
import de.alpharogroup.tree.ifaces.ITreeNode;
import de.alpharogroup.wicket.components.tree.provider.TopicsTreePanel;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.ResourceBundle;
import org.apache.wicket.Session;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortState;
import org.apache.wicket.extensions.markup.html.repeater.tree.ISortableTreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.util.SingleSortState;
import org.apache.wicket.extensions.markup.html.repeater.util.SortParam;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.LoadableDetachableModel;

public class TopicTreeNodeProvider
implements ISortableTreeProvider<ITreeNode<Topics>, String> {
    private static final long serialVersionUID = 1L;
    private final List<ITreeNode<Topics>> roots = new ArrayList<ITreeNode<Topics>>();
    private SingleSortState<String> sortState;

    public TopicTreeNodeProvider(ITreeNode<Topics> root) {
        this.roots.add(root);
        this.sortState = new SingleSortState();
    }

    public void detach() {
    }

    private ITreeNode<Topics> get(List<ITreeNode<Topics>> treeNodes, String id) {
        for (ITreeNode<Topics> treeNode : treeNodes) {
            if (((Integer)((Topics)treeNode.getValue()).getId()).toString().equals(id)) {
                return treeNode;
            }
            ITreeNode<Topics> tmp = this.get(treeNode.getChildren(), id);
            if (tmp == null) continue;
            return tmp;
        }
        return null;
    }

    public ITreeNode<Topics> get(String id) {
        return this.get(this.roots, id);
    }

    public Iterator<? extends ITreeNode<Topics>> getChildren(ITreeNode<Topics> treeNode) {
        return treeNode.getChildren().iterator();
    }

    public Iterator<? extends ITreeNode<Topics>> getRoots() {
        return this.roots.iterator();
    }

    public SortParam<String> getSort() {
        return this.sortState.getSort();
    }

    public final ISortState<String> getSortState() {
        return this.sortState;
    }

    public boolean hasChildren(ITreeNode<Topics> treeNode) {
        return treeNode.hasChildren();
    }

    public IModel<ITreeNode<Topics>> model(ITreeNode<Topics> treeNode) {
        return new TreeNodeModel(treeNode);
    }

    public void setSort(SortParam<String> param) {
        this.sortState.setSort(param);
    }

    public void setSort(String property, boolean ascending) {
        this.setSort((SortParam<String>)new SortParam((Object)property, ascending));
    }

    public final void setSortState(ISortState<String> state) {
        if (!(state instanceof SingleSortState)) {
            throw new IllegalArgumentException("argument [sortState] must be an instance of SingleSortState, but it is [" + state.getClass().getName() + "]:[" + state.toString() + "]");
        }
        this.sortState = (SingleSortState)state;
    }

    private class TreeNodeModel
    extends LoadableDetachableModel<ITreeNode<Topics>> {
        private static final long serialVersionUID = 1L;
        private final String id;

        public TreeNodeModel(ITreeNode<Topics> treeNode) {
            super(treeNode);
            this.id = ((Integer)((Topics)treeNode.getValue()).getId()).toString();
            String propertiesKey = ((Topics)treeNode.getValue()).getName();
            String topicTreeName = ResourceBundleExtensions.getString((ResourceBundle)ResourceBundle.getBundle(TopicsTreePanel.class.getName(), Session.get().getLocale()), (String)propertiesKey, (Object[])new Object[0]);
            treeNode.setDisplayValue(topicTreeName);
        }

        public boolean equals(Object obj) {
            if (obj instanceof TreeNodeModel) {
                return ((TreeNodeModel)((Object)obj)).id.equals(this.id);
            }
            return false;
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + (this.id == null ? 0 : this.id.hashCode());
            return result;
        }

        protected ITreeNode<Topics> load() {
            return TopicTreeNodeProvider.this.get(this.id);
        }
    }
}

