/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.tree.panel;

import de.alpharogroup.io.annotations.ImportResource;
import de.alpharogroup.io.annotations.ImportResources;
import de.alpharogroup.wicket.components.tree.model.Content;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.theme.HumanTheme;
import org.apache.wicket.extensions.markup.html.repeater.tree.theme.WindowsTheme;
import org.apache.wicket.extensions.markup.html.repeater.util.ProviderSubset;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.AbstractReadOnlyModel;
import org.apache.wicket.model.IDetachable;
import org.apache.wicket.model.IModel;

@ImportResources(resources={@ImportResource(resourceName="AbstractTreePanel.css", resourceType="css")})
public abstract class AbstractTreePanel<T>
extends Panel {
    private static final long serialVersionUID = 1L;
    private Content<T> content;
    protected List<Content<T>> contents;
    private ITreeProvider<T> treeProvider;
    private Set<T> state;
    private Behavior theme;
    private List<Behavior> themes;
    private AbstractTree<T> tree;

    public AbstractTreePanel(String id, ITreeProvider<T> treeProvider, ProviderSubset<T> state, Content<T> content) {
        super(id);
        this.treeProvider = treeProvider;
        this.content = content;
        this.state = state;
        this.tree = this.createTree(treeProvider, this.newStateModel());
        this.tree.add(new Behavior[]{this.theme});
        this.initThemes();
    }

    protected abstract AbstractTree<T> createTree(ITreeProvider<T> var1, IModel<Set<T>> var2);

    public void detachModels() {
        for (Content<T> content : this.contents) {
            content.detach();
        }
        super.detachModels();
    }

    public Content<T> getContent() {
        return this.content;
    }

    public List<Content<T>> getContents() {
        return this.contents;
    }

    public AbstractTree<T> getTree() {
        return this.tree;
    }

    public ITreeProvider<T> getTreeProvider() {
        return this.treeProvider;
    }

    protected abstract List<Content<T>> initContents();

    private List<Behavior> initThemes() {
        this.themes = new ArrayList<Behavior>();
        this.themes.add((Behavior)new WindowsTheme());
        this.themes.add((Behavior)new HumanTheme());
        this.theme = this.themes.get(0);
        return this.themes;
    }

    protected Component newContentComponent(String id, IModel<T> model) {
        return this.content.newContentComponent(id, this.tree, model);
    }

    private IModel<Set<T>> newStateModel() {
        return new AbstractReadOnlyModel<Set<T>>(){
            private static final long serialVersionUID = 1L;

            public void detach() {
                ((IDetachable)AbstractTreePanel.this.state).detach();
            }

            public Set<T> getObject() {
                return AbstractTreePanel.this.state;
            }
        };
    }

    protected void setContent(Content<T> content) {
        this.content = content;
    }

    protected abstract void setContents(List<Content<T>> var1);

    protected void setTree(AbstractTree<T> tree) {
        this.tree = tree;
    }
}

