/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.tree.content;

import de.alpharogroup.event.system.entities.Topics;
import de.alpharogroup.tree.ifaces.ITreeNode;
import de.alpharogroup.wicket.components.tree.content.ICheckFolderContent;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.extensions.markup.html.repeater.tree.AbstractTree;
import org.apache.wicket.extensions.markup.html.repeater.tree.ITreeProvider;
import org.apache.wicket.extensions.markup.html.repeater.tree.content.CheckedFolder;
import org.apache.wicket.extensions.markup.html.repeater.util.ProviderSubset;
import org.apache.wicket.model.IModel;
import org.apache.wicket.request.cycle.RequestCycle;

public class CheckedFolderContent
implements ICheckFolderContent<ITreeNode<Topics>> {
    private static final long serialVersionUID = 1L;
    private ProviderSubset<ITreeNode<Topics>> checked;
    private final Map<ITreeNode<Topics>, Boolean> topicsMap;

    public CheckedFolderContent(ITreeProvider<ITreeNode<Topics>> provider, Map<ITreeNode<Topics>, Boolean> topicsMap) {
        this.checked = new ProviderSubset(provider, false);
        this.topicsMap = topicsMap;
        Set<ITreeNode<Topics>> treenodes = this.topicsMap.keySet();
        for (ITreeNode<Topics> treeNode : treenodes) {
            this.check(treeNode, true, (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class));
        }
    }

    @Override
    public void check(ITreeNode<Topics> topic, boolean check, AjaxRequestTarget target) {
        if (check) {
            this.checked.add(topic);
            this.topicsMap.put(topic, check);
        } else {
            this.checked.remove(topic);
            this.topicsMap.remove(topic);
        }
    }

    public void detach() {
        this.checked.detach();
    }

    public ProviderSubset<ITreeNode<Topics>> getChecked() {
        return this.checked;
    }

    public List<Topics> getCheckedTopics() {
        ProviderSubset<ITreeNode<Topics>> ct = this.getChecked();
        ArrayList<Topics> checkedTopics = new ArrayList<Topics>();
        if (ct != null && !ct.isEmpty()) {
            for (ITreeNode iTreeNode : ct) {
                checkedTopics.add((Topics)iTreeNode.getValue());
            }
        }
        return checkedTopics;
    }

    @Override
    public boolean isChecked(ITreeNode<Topics> topic) {
        return this.checked.contains(topic);
    }

    @Override
    public Component newContentComponent(String id, AbstractTree<ITreeNode<Topics>> tree, IModel<ITreeNode<Topics>> model) {
        return new CheckedFolder<ITreeNode<Topics>>(id, tree, model){
            private static final long serialVersionUID = 1L;

            protected IModel<Boolean> newCheckBoxModel(final IModel<ITreeNode<Topics>> model) {
                return new IModel<Boolean>(){
                    private static final long serialVersionUID = 1L;

                    public void detach() {
                    }

                    public Boolean getObject() {
                        ITreeNode treeNode = (ITreeNode)model.getObject();
                        boolean isChecked = CheckedFolderContent.this.isChecked((ITreeNode<Topics>)treeNode);
                        CheckedFolderContent.this.topicsMap.put(treeNode, new Boolean(isChecked));
                        return isChecked;
                    }

                    public void setObject(Boolean object) {
                        CheckedFolderContent.this.check((ITreeNode<Topics>)((ITreeNode)model.getObject()), (boolean)object, (AjaxRequestTarget)RequestCycle.get().find(AjaxRequestTarget.class));
                    }
                };
            }
        };
    }
}

