/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.sign.up.search;

import de.alpharogroup.address.book.application.model.LocationModel;
import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.sign.up.search.LocationPanel;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.markup.html.form.AjaxButton;
import org.apache.wicket.extensions.ajax.markup.html.IndicatingAjaxButton;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;

public abstract class SearchLocationFormPanel
extends GenericPanel<LocationModel<Addresses>> {
    private static final long serialVersionUID = 1L;
    private final AjaxButton submitButton;
    private final Label buttonLabel;
    private final LocationPanel locationPanel;
    private final Form<?> form;

    public SearchLocationFormPanel(String id, IModel<LocationModel<Addresses>> model) {
        super(id, model);
        Component[] componentArray = new Component[1];
        this.form = this.newForm("form");
        componentArray[0] = this.form;
        this.add(componentArray);
        this.form.setOutputMarkupId(true);
        this.locationPanel = this.newLocationPanel("locationPanel", model);
        this.form.add(new Component[]{this.locationPanel});
        this.submitButton = this.newButton("submitButton", model);
        this.buttonLabel = this.newButtonLabel("buttonLabel", this.newButtonResourceKey(), "Ausw\u00e4hlen", (Component)this);
        this.submitButton.add(new Component[]{this.buttonLabel});
        this.form.add(new Component[]{this.submitButton});
    }

    public AjaxButton getSubmitButton() {
        return this.submitButton;
    }

    protected AjaxButton newButton(String id, final IModel<LocationModel<Addresses>> model) {
        return new IndicatingAjaxButton(id, this.form){
            private static final long serialVersionUID = 1L;

            protected void onError(AjaxRequestTarget target, Form<?> form) {
                SearchLocationFormPanel.this.onError(target, form);
            }

            protected void onSubmit(AjaxRequestTarget target, Form<?> form) {
                target.add(new Component[]{form});
                LocationModel object = (LocationModel)model.getObject();
                String countryName = (String)SearchLocationFormPanel.this.locationPanel.getCountryWithZipDropDownChoiceTextFieldPanel().getStringTwoDropDownChoicesModel().getSelectedRootOption();
                object.setSelectedCountryName(countryName);
                String location = SearchLocationFormPanel.this.locationPanel.getCountryWithZipDropDownChoiceTextFieldPanel().getZipcode().getDefaultModelObjectAsString();
                object.setLocation(location);
                SearchLocationFormPanel.this.onSearch(target, (LocationModel<Addresses>)((LocationModel)model.getObject()));
            }
        };
    }

    protected Label newButtonLabel(String id, String resourceKey, String defaultValue, Component component) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)resourceKey, (Component)component, (String)defaultValue);
        Label label = new Label(id, labelModel);
        label.setOutputMarkupId(true);
        return label;
    }

    protected String newButtonResourceKey() {
        return "global.choose.label";
    }

    protected Form<?> newForm(String id) {
        Form form = new Form(id);
        form.setOutputMarkupId(true);
        return form;
    }

    protected abstract LocationPanel newLocationPanel(String var1, IModel<LocationModel<Addresses>> var2);

    protected void onError(AjaxRequestTarget target, Form<?> form) {
    }

    public abstract void onSearch(AjaxRequestTarget var1, LocationModel<Addresses> var2);

    public Label getButtonLabel() {
        return this.buttonLabel;
    }

    public LocationPanel getLocationPanel() {
        return this.locationPanel;
    }

    public Form<?> getForm() {
        return this.form;
    }
}

