/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.infringement.input;

import de.alpharogroup.user.management.application.models.InfringementModel;
import de.alpharogroup.user.management.enums.RuleViolationReason;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.behaviors.JQueryJsAppenderBehavior;
import de.alpharogroup.wicket.bootstrap3.components.labeled.textarea.BootstrapLabeledTextAreaPanel;
import de.alpharogroup.wicket.components.i18n.dropdownchoice.EnumLocalizedDropdownChoicePanel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.StringResourceModel;

public class InfringementInputPanel
extends Panel {
    private static final long serialVersionUID = 1L;
    private final Component reason;
    private final Component description;

    public InfringementInputPanel(String id, IModel<InfringementModel> model) {
        super(id, model);
        CompoundPropertyModel cpm = new CompoundPropertyModel(model);
        this.reason = this.newReason("reason", (IModel<InfringementModel>)cpm);
        this.add(new Component[]{this.reason});
        this.description = this.newDescription("description", (IModel<InfringementModel>)cpm);
        this.add(new Component[]{this.description});
    }

    public Component getDescription() {
        return this.description;
    }

    public Component getReason() {
        return this.reason;
    }

    protected Component newDescription(String id, IModel<InfringementModel> model) {
        IModel labelModel = ResourceModelFactory.newResourceModel((String)"rule.violation.reason.description.label", (Component)this, (String)"Description");
        IModel placeholderModel = ResourceModelFactory.newResourceModel((String)"global.enter.your.rule.violation.reason.description.label", (Component)this, (String)"Enter your description for the rule violation");
        BootstrapLabeledTextAreaPanel description = new BootstrapLabeledTextAreaPanel("description", model, labelModel, placeholderModel);
        description.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"pull-left"))});
        description.getTextArea().add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"field span5"))});
        description.getTextArea().add(new Behavior[]{new AttributeAppender("rows", (Serializable)((Object)"10"))});
        description.setRequired(true);
        return description;
    }

    protected Component newReason(String id, IModel<InfringementModel> model) {
        RuleViolationReason[] values = RuleViolationReason.values();
        ArrayList<RuleViolationReason> violationReasons = new ArrayList<RuleViolationReason>(Arrays.asList(values));
        StringResourceModel genderLabelModel = new StringResourceModel("rule.violation.dropdown.reason.label", (Component)this, null);
        EnumLocalizedDropdownChoicePanel reason = new EnumLocalizedDropdownChoicePanel("reason", model, (IModel)genderLabelModel, violationReasons);
        reason.getDropdownChoice().add(new Behavior[]{new JQueryJsAppenderBehavior((CharSequence)"wrap", (CharSequence)"<div class=\"span3dot5\"></div>")});
        reason.setRequired(true);
        return reason;
    }
}

