/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.inbox.send;

import de.alpharogroup.message.system.application.models.send.SendMessagePanelModel;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.labeled.textarea.LabeledTextAreaPanel;
import de.alpharogroup.wicket.components.labeled.textfield.LabeledTextFieldPanel;
import java.io.Serializable;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.Button;
import org.apache.wicket.markup.html.form.Form;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.StringResourceModel;
import org.apache.wicket.request.mapper.parameter.PageParameters;

public abstract class AbstractSendMessagePanel
extends Panel {
    private static final long serialVersionUID = 1L;
    protected final Form<SendMessagePanelModel> form;
    protected final Component recipient;
    protected final Component subject;
    protected final LabeledTextAreaPanel<String, SendMessagePanelModel> messageContent;
    protected final Button sendButton;
    protected final Label sendMessageLabel;

    public AbstractSendMessagePanel(String id, PageParameters parameters) {
        super(id);
        SendMessagePanelModel modelObject = this.onSendMessageModel(parameters);
        this.setDefaultModel((IModel)Model.of((Serializable)modelObject));
        CompoundPropertyModel cpm = new CompoundPropertyModel((Object)modelObject);
        this.form = new Form("form", (IModel)cpm);
        this.add(new Component[]{this.form});
        Component[] componentArray = new Component[1];
        this.sendMessageLabel = this.newLabel("sendMessageLabel", this.newSendMessageLabelModel());
        componentArray[0] = this.sendMessageLabel;
        this.form.add(componentArray);
        this.recipient = this.newRecipientPanel("recipient", (IModel<SendMessagePanelModel>)cpm);
        this.form.add(new Component[]{this.recipient});
        this.subject = this.newSubjectPanel("subject", (IModel<SendMessagePanelModel>)cpm);
        this.form.add(new Component[]{this.subject});
        StringResourceModel messageContentModel = new StringResourceModel("inbox.message.label", (Component)this, null);
        this.messageContent = new LabeledTextAreaPanel("messageContent", (IModel)cpm, (IModel)messageContentModel);
        this.messageContent.getTextArea().add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"labeledFormElement"))});
        this.form.add(new Component[]{this.messageContent});
        this.sendButton = new Button("sendButton"){
            private static final long serialVersionUID = 1L;

            public void onSubmit() {
                AbstractSendMessagePanel.this.onSendMessage();
            }
        };
        StringResourceModel buttonLabelModel = new StringResourceModel("inbox.send.button.label", (Component)this, null);
        this.sendButton.add(new Component[]{new Label("buttonLabel", (IModel)buttonLabelModel)});
        this.form.add(new Component[]{this.sendButton});
    }

    protected Label newLabel(String id, IModel<String> model) {
        Label label = new Label(id, model);
        return label;
    }

    protected Component newRecipientPanel(String id, IModel<SendMessagePanelModel> model) {
        LabeledTextFieldPanel panel = new LabeledTextFieldPanel(id, model, ResourceModelFactory.newResourceModel((String)"inbox.recipient.label", (Component)this));
        panel.getTextField().add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"labeledFormElement"))});
        if (((SendMessagePanelModel)model.getObject()).getRecipient() != null) {
            panel.getTextField().setEnabled(false);
        }
        return panel;
    }

    protected IModel<String> newSendMessageLabelModel() {
        return ResourceModelFactory.newResourceModel((String)"inbox.send.message.header.label", (Component)this);
    }

    protected Component newSubjectPanel(String id, IModel<SendMessagePanelModel> model) {
        LabeledTextFieldPanel panel = new LabeledTextFieldPanel(id, model, ResourceModelFactory.newResourceModel((String)"inbox.subject.label", (Component)this));
        panel.getTextField().add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"labeledFormElement"))});
        return panel;
    }

    protected abstract void onSendMessage();

    protected abstract SendMessagePanelModel onSendMessageModel(PageParameters var1);
}

