/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.inbox;

import de.alpharogroup.message.system.entities.Messages;
import de.alpharogroup.message.system.enums.MessageState;
import de.alpharogroup.wicket.model.provider.MessagesProvider;
import java.io.Serializable;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.ISortStateLocator;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.OrderByLink;
import org.apache.wicket.extensions.markup.html.repeater.data.sort.SortOrder;
import org.apache.wicket.extensions.markup.html.repeater.data.table.NavigatorLabel;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.link.Link;
import org.apache.wicket.markup.html.navigation.paging.IPageable;
import org.apache.wicket.markup.html.navigation.paging.IPageableItems;
import org.apache.wicket.markup.html.navigation.paging.PagingNavigator;
import org.apache.wicket.markup.html.panel.Panel;
import org.apache.wicket.markup.repeater.Item;
import org.apache.wicket.markup.repeater.data.DataView;
import org.apache.wicket.markup.repeater.data.IDataProvider;
import org.apache.wicket.model.CompoundPropertyModel;
import org.apache.wicket.model.IModel;

public abstract class AbstractMessagesPanel
extends Panel {
    private static final long serialVersionUID = 1L;

    public AbstractMessagesPanel(String id, final MessageState state) {
        super(id);
        List<Messages> inboxMessages = this.getInboxMessages(state);
        MessagesProvider dataProvider = new MessagesProvider(inboxMessages){
            private static final long serialVersionUID = 1L;

            public List<Messages> getData() {
                return AbstractMessagesPanel.this.getInboxMessages(state);
            }
        };
        dataProvider.setSort((Serializable)((Object)"sentDate"), SortOrder.ASCENDING);
        WebMarkupContainer noresults = new WebMarkupContainer("noresults");
        this.add(new Component[]{noresults});
        WebMarkupContainer results = new WebMarkupContainer("results");
        this.add(new Component[]{results});
        if (0L < dataProvider.size()) {
            results.setVisible(true);
            noresults.setVisible(false);
            noresults.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"displaynone"))});
        } else {
            results.setVisible(false);
            results.add(new Behavior[]{new AttributeAppender("class", (Serializable)((Object)"displaynone"))});
            noresults.setVisible(true);
        }
        DataView<Messages> dataView = new DataView<Messages>("dataView", (IDataProvider)dataProvider){
            private static final long serialVersionUID = 1L;

            protected void populateItem(Item<Messages> item) {
                final Messages messageModel = (Messages)item.getModelObject();
                item.setDefaultModel((IModel)new CompoundPropertyModel((Object)messageModel));
                item.add(new Component[]{new Label("state")});
                item.add(new Component[]{new Label("sender.username")});
                item.add(new Component[]{new Label("subject")});
                item.add(new Component[]{new Label("sentDate")});
                item.add(new Component[]{new Link<String>("readMessageLink"){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        AbstractMessagesPanel.this.onRead(messageModel);
                    }
                }});
                item.add(new Component[]{new Link<String>("deleteMessageLink"){
                    private static final long serialVersionUID = 1L;

                    public void onClick() {
                        AbstractMessagesPanel.this.onDelete(messageModel);
                    }
                }});
            }
        };
        dataView.setItemsPerPage(10L);
        results.add(new Component[]{new NavigatorLabel("label", (IPageableItems)dataView)});
        results.add(new Component[]{new PagingNavigator("navigator", (IPageable)dataView)});
        results.add(new Component[]{new OrderByLink("sortState", (Object)"state", (ISortStateLocator)dataProvider)});
        results.add(new Component[]{new OrderByLink("sortSenderUsername", (Object)"sender.username", (ISortStateLocator)dataProvider)});
        results.add(new Component[]{new OrderByLink("sortSubject", (Object)"subject", (ISortStateLocator)dataProvider)});
        results.add(new Component[]{new OrderByLink("sortSentDate", (Object)"sentDate", (ISortStateLocator)dataProvider)});
        results.add(new Component[]{dataView});
    }

    protected abstract List<Messages> getInboxMessages(MessageState var1);

    protected abstract void onDelete(Messages var1);

    protected abstract void onRead(Messages var1);
}

