/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.address.countries.zipcodes;

import de.alpharogroup.address.book.application.model.LocationModel;
import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.wicket.components.i18n.dropdownchoice.LocalisedDropDownChoice;
import de.alpharogroup.wicket.model.dropdownchoices.StringTwoDropDownChoicesModel;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.wicket.Component;
import org.apache.wicket.ajax.AjaxRequestTarget;
import org.apache.wicket.ajax.form.AjaxFormComponentUpdatingBehavior;
import org.apache.wicket.behavior.AttributeAppender;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.AutoCompleteTextField;
import org.apache.wicket.extensions.ajax.markup.html.autocomplete.DefaultCssAutoCompleteTextField;
import org.apache.wicket.markup.html.WebMarkupContainer;
import org.apache.wicket.markup.html.basic.Label;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;
import org.apache.wicket.util.lang.Args;
import org.apache.wicket.util.string.Strings;

public class DropDownChoiceTextFieldPanel
extends GenericPanel<StringTwoDropDownChoicesModel> {
    private static final long serialVersionUID = 1L;
    private final LocalisedDropDownChoice<String> rootChoice;
    private final StringTwoDropDownChoicesModel stringTwoDropDownChoicesModel;
    private final WebMarkupContainer wmcChildChoice;
    protected final Label rootLabel;
    protected Label childLabel;
    private final WebMarkupContainer wmcRootChoice;
    private final AutoCompleteTextField<String> zipcode;

    public DropDownChoiceTextFieldPanel(String id, StringTwoDropDownChoicesModel stringTwoDropDownChoicesModel, IChoiceRenderer<String> rootRenderer, IModel<String> rootLabelModel, IModel<String> childLabelModel, IModel<LocationModel<Addresses>> locationModel) {
        super(id, (IModel)Model.of((Serializable)((Serializable)Args.notNull((Object)stringTwoDropDownChoicesModel, (String)"stringTwoDropDownChoicesModel"))));
        this.stringTwoDropDownChoicesModel = stringTwoDropDownChoicesModel;
        this.rootChoice = this.newLocalisedDropDownChoice("rootChoice", (IModel<String>)new PropertyModel((Object)this.stringTwoDropDownChoicesModel, "selectedRootOption"), (IModel<? extends List<? extends String>>)this.stringTwoDropDownChoicesModel.getRootChoices(), rootRenderer);
        String rootMarkupId = this.rootChoice.getMarkupId();
        this.wmcRootChoice = new WebMarkupContainer("wmcRootChoice");
        this.wmcRootChoice.setOutputMarkupId(true);
        this.add(new Component[]{this.wmcRootChoice});
        Component[] componentArray = new Component[1];
        this.rootLabel = this.newRootLabel(rootMarkupId, rootLabelModel);
        componentArray[0] = this.rootLabel;
        this.wmcRootChoice.add(componentArray);
        this.wmcRootChoice.add(new Component[]{this.getRootChoice()});
        this.zipcode = this.newAutoCompleteTextField("zipcode", (IModel<String>)new PropertyModel(locationModel, "location"));
        String childMarkupId = this.zipcode.getMarkupId();
        this.zipcode.setOutputMarkupId(true);
        this.wmcChildChoice = new WebMarkupContainer("wmcChildChoice");
        this.wmcChildChoice.setOutputMarkupId(true);
        this.add(new Component[]{this.wmcChildChoice});
        Component[] componentArray2 = new Component[1];
        this.childLabel = this.newChildLabel(childMarkupId, childLabelModel);
        componentArray2[0] = this.childLabel;
        this.wmcChildChoice.add(componentArray2);
        this.wmcChildChoice.add(new Component[]{this.zipcode});
        this.rootChoice.add(new Behavior[]{new AjaxFormComponentUpdatingBehavior("change"){
            private static final long serialVersionUID = 1L;

            protected void onUpdate(AjaxRequestTarget target) {
                target.add(new Component[]{DropDownChoiceTextFieldPanel.this.zipcode});
            }
        }});
    }

    protected AutoCompleteTextField<String> newAutoCompleteTextField(String id, IModel<String> model) {
        DefaultCssAutoCompleteTextField<String> autoCompleteTextField = new DefaultCssAutoCompleteTextField<String>(id, model){
            private static final long serialVersionUID = 1L;

            protected Iterator<String> getChoices(String input) {
                if (Strings.isEmpty((CharSequence)input)) {
                    List emptyList = Collections.emptyList();
                    return emptyList.iterator();
                }
                ArrayList<String> choices = new ArrayList<String>(10);
                List childChoices = (List)DropDownChoiceTextFieldPanel.this.stringTwoDropDownChoicesModel.getChildChoices().getObject();
                for (String choice : childChoices) {
                    if (!choice.toUpperCase().startsWith(input.toUpperCase())) continue;
                    choices.add(choice);
                    if (choices.size() != 20) continue;
                    break;
                }
                return choices.iterator();
            }
        };
        return autoCompleteTextField;
    }

    protected Label newChildLabel(String forId, IModel<String> model) {
        return this.newLabel("childLabel", forId, model);
    }

    private Label newLabel(String id, String forId, IModel<String> model) {
        Label label = new Label(id, model);
        label.setOutputMarkupId(true);
        label.add(new Behavior[]{new AttributeAppender("for", (IModel)Model.of((Serializable)((Object)forId)), " ")});
        return label;
    }

    protected LocalisedDropDownChoice<String> newLocalisedDropDownChoice(String id, IModel<String> model, IModel<? extends List<? extends String>> choices, IChoiceRenderer<? super String> renderer) {
        LocalisedDropDownChoice dropdown = new LocalisedDropDownChoice(id, model, choices, renderer);
        dropdown.setOutputMarkupId(true);
        return dropdown;
    }

    protected Label newRootLabel(String forId, IModel<String> model) {
        return this.newLabel("rootLabel", forId, model);
    }

    public LocalisedDropDownChoice<String> getRootChoice() {
        return this.rootChoice;
    }

    public StringTwoDropDownChoicesModel getStringTwoDropDownChoicesModel() {
        return this.stringTwoDropDownChoicesModel;
    }

    public WebMarkupContainer getWmcChildChoice() {
        return this.wmcChildChoice;
    }

    public Label getRootLabel() {
        return this.rootLabel;
    }

    public Label getChildLabel() {
        return this.childLabel;
    }

    public WebMarkupContainer getWmcRootChoice() {
        return this.wmcRootChoice;
    }

    public AutoCompleteTextField<String> getZipcode() {
        return this.zipcode;
    }
}

