/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.components.address;

import de.alpharogroup.address.book.entities.Addresses;
import de.alpharogroup.address.book.entities.Federalstates;
import de.alpharogroup.address.book.entities.Zipcodes;
import de.alpharogroup.address.book.factories.AddressBookFactory;
import de.alpharogroup.collections.ListExtensions;
import de.alpharogroup.resourcebundle.locale.ResourceBundleKey;
import de.alpharogroup.wicket.base.util.resource.ResourceModelFactory;
import de.alpharogroup.wicket.components.address.AddressBean;
import de.alpharogroup.wicket.components.address.countries.CountriesProvincesPanel;
import de.alpharogroup.wicket.components.form.input.TwoFormComponentBean;
import de.alpharogroup.wicket.components.i18n.dropdownchoice.renderers.PropertiesChoiceRenderer;
import de.alpharogroup.wicket.components.labeled.LabeledTwoFormComponentPanel;
import de.alpharogroup.wicket.model.dropdownchoices.StringTwoDropDownChoicesModel;
import de.alpharogroup.wicket.model.dropdownchoices.TwoDropDownChoicesModel;
import java.io.Serializable;
import org.apache.wicket.AttributeModifier;
import org.apache.wicket.Component;
import org.apache.wicket.behavior.Behavior;
import org.apache.wicket.markup.html.form.IChoiceRenderer;
import org.apache.wicket.markup.html.panel.GenericPanel;
import org.apache.wicket.model.IModel;
import org.apache.wicket.model.Model;
import org.apache.wicket.model.PropertyModel;

public class AddressPanel
extends GenericPanel<AddressBean> {
    private static final long serialVersionUID = 1L;

    public AddressPanel(String id, IModel<AddressBean> model) {
        super(id, model);
        this.add(new Component[]{this.newStreetNumberPanel("streetNumberPanel", model)});
        this.add(new Component[]{this.newZipcodeCityPanel("zipcodeCityPanel", model)});
        this.add(new Component[]{this.newCountriesProvincesPanel("countriesProvincesPanel", this.newTwoDropDownChoicesModel(model))});
    }

    protected IModel<String> newBetweenLabelModel() {
        return Model.of((Serializable)((Object)"/"));
    }

    protected CountriesProvincesPanel newCountriesProvincesPanel(String id, IModel<TwoDropDownChoicesModel<String>> stringTwoDropDownChoicesModel) {
        CountriesProvincesPanel countriesProvincesPanel = new CountriesProvincesPanel("countriesProvincesPanel", stringTwoDropDownChoicesModel, (IChoiceRenderer<String>)new PropertiesChoiceRenderer((Component)this, AddressPanel.class), (IChoiceRenderer<String>)new PropertiesChoiceRenderer((Component)this, AddressPanel.class));
        AttributeModifier samWmcRoot = new AttributeModifier("class", (Serializable)((Object)"countries"));
        AttributeModifier sam = new AttributeModifier("class", (Serializable)((Object)"countries"));
        countriesProvincesPanel.getWmcRootChoice().add(new Behavior[]{samWmcRoot});
        countriesProvincesPanel.getRootChoice().add(new Behavior[]{sam});
        AttributeModifier samWmcChild = new AttributeModifier("class", (Serializable)((Object)"federalstates"));
        countriesProvincesPanel.getWmcChildChoice().add(new Behavior[]{samWmcChild});
        countriesProvincesPanel.getChildChoice().add(new Behavior[]{sam});
        countriesProvincesPanel.getChildChoice().setRequired(true);
        return countriesProvincesPanel;
    }

    protected Component newStreetNumberPanel(String id, IModel<AddressBean> model) {
        String betweenLabel = (String)this.newBetweenLabelModel().getObject();
        PropertyModel streetModel = new PropertyModel(model, "address.street");
        PropertyModel streetNumberModel = new PropertyModel(model, "address.streetnumber");
        TwoFormComponentBean streetNumberTwoFormComponentBean = new TwoFormComponentBean((IModel)streetModel, (IModel)streetNumberModel);
        LabeledTwoFormComponentPanel<String, String, AddressBean> streetNumberPanel = new LabeledTwoFormComponentPanel<String, String, AddressBean>(id, model, (IModel)Model.of((Serializable)streetNumberTwoFormComponentBean), ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("sem.main.address.street.and.nr.label").parameters(ListExtensions.toObjectArray((Object[])new String[]{betweenLabel})).defaultValue("Street, Number:").build(), (Component)this)){
            private static final long serialVersionUID = 1L;

            protected IModel<String> newBetweenLabelModel(String betweenLabel) {
                return AddressPanel.this.newBetweenLabelModel();
            }
        };
        return streetNumberPanel;
    }

    private IModel<TwoDropDownChoicesModel<String>> newTwoDropDownChoicesModel(IModel<AddressBean> model) {
        AddressBean modelObject = (AddressBean)model.getObject();
        StringTwoDropDownChoicesModel stringTwoDropDownChoicesModel = modelObject.getCountriesAndProvincesDropDownChoicesModel();
        Addresses address = modelObject.getAddress();
        if (address != null) {
            Federalstates federalState = modelObject.getAddress().getFederalstate();
            if (federalState != null) {
                stringTwoDropDownChoicesModel.setSelectedRootOption((Object)federalState.getCountry().getName());
                stringTwoDropDownChoicesModel.setSelectedChildOption((Object)federalState.getIso3166A2code());
            }
        } else {
            Zipcodes zc = AddressBookFactory.getInstance().newZipcodes(null, "", "");
            Addresses initialAddress = AddressBookFactory.getInstance().newAddresses("", null, null, null, null, "", "", zc);
            modelObject.setAddress(initialAddress);
        }
        Model twoDropDownChoicesModel = Model.of((Serializable)stringTwoDropDownChoicesModel);
        return twoDropDownChoicesModel;
    }

    protected Component newZipcodeCityPanel(String id, IModel<AddressBean> model) {
        String betweenLabel = (String)this.newBetweenLabelModel().getObject();
        PropertyModel zipcodeModel = new PropertyModel(model, "address.zipcode.zipcode");
        PropertyModel cityModel = new PropertyModel(model, "address.zipcode.city");
        TwoFormComponentBean zipcodeCityTwoFormComponentBean = new TwoFormComponentBean((IModel)zipcodeModel, (IModel)cityModel);
        LabeledTwoFormComponentPanel<String, String, AddressBean> streetNumberPanel = new LabeledTwoFormComponentPanel<String, String, AddressBean>(id, model, (IModel)Model.of((Serializable)zipcodeCityTwoFormComponentBean), ResourceModelFactory.newResourceModel((ResourceBundleKey)ResourceBundleKey.builder().key("sem.main.address.zipcode.and.city.label").parameters(ListExtensions.toObjectArray((Object[])new String[]{betweenLabel})).defaultValue("Zipcode, City:").build(), (Component)this)){
            private static final long serialVersionUID = 1L;

            protected IModel<String> newBetweenLabelModel(String betweenLabel) {
                return AddressPanel.this.newBetweenLabelModel();
            }
        };
        return streetNumberPanel;
    }
}

