/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.application;

import de.alpharogroup.date.CreateDateExtensions;
import de.alpharogroup.file.checksum.Algorithm;
import de.alpharogroup.file.checksum.ChecksumExtensions;
import de.alpharogroup.resource.system.application.model.ResourcesModel;
import de.alpharogroup.resource.system.application.util.ModelConverter;
import de.alpharogroup.resource.system.entities.Resources;
import java.util.List;
import org.apache.wicket.markup.html.form.upload.FileUpload;
import org.apache.wicket.model.util.ListModel;

public class WicketModelConverter {
    public static ListModel<ResourcesModel> toResourceModelList(List<Resources> resources) {
        return new ListModel(ModelConverter.toResourcesModel(resources));
    }

    public static ResourcesModel toResourcesModel(FileUpload upload, ResourcesModel model, String description) {
        model.setContent(upload.getBytes());
        model.setContentType(upload.getContentType());
        model.setDescription(description);
        model.setFilename(upload.getClientFileName());
        model.setFilesize(upload.getSize() + "");
        model.setCreated(CreateDateExtensions.now());
        model.setChecksum(ChecksumExtensions.getChecksumQuietly((byte[])upload.getBytes(), (String)Algorithm.SHA_256.getAlgorithm()));
        model.setDeletedFlag(Boolean.FALSE);
        return model;
    }
}

