/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.wicket.application;

import de.alpharogroup.user.entities.Roles;
import de.alpharogroup.user.entities.Users;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.apache.wicket.Session;
import org.apache.wicket.protocol.http.WebSession;
import org.apache.wicket.request.Request;

public abstract class AbstractWicketSession<USERID>
extends WebSession {
    private static final long serialVersionUID = 4729651101693312649L;
    private List<Roles> roles;
    private final Map<String, Serializable> userAttributes = new LinkedHashMap<String, Serializable>();
    protected USERID userId;

    public static AbstractWicketSession get() {
        return (AbstractWicketSession)Session.get();
    }

    public AbstractWicketSession(Request request) {
        super(request);
    }

    public synchronized List<Roles> getRoles() {
        return this.roles;
    }

    public abstract Users getUser();

    public synchronized Serializable getUserAttribute(String key) {
        return this.userAttributes.get(key);
    }

    public synchronized USERID getUserId() {
        return this.userId;
    }

    public synchronized void invalidate() {
        super.invalidate();
        this.setUserId(null);
        this.setUser(null);
    }

    public synchronized void invalidateNow() {
        super.invalidateNow();
        this.setUserId(null);
        this.setUser(null);
    }

    public synchronized boolean isGuest() {
        return !this.isSignedIn();
    }

    public synchronized boolean isInRole(Roles role) {
        List<Roles> roles = this.getRoles();
        return roles != null && !roles.isEmpty() && roles.contains(role);
    }

    public synchronized boolean isInRole(String rolename) {
        List<Roles> roles = this.getRoles();
        if (null != roles && !roles.isEmpty()) {
            for (Roles role : roles) {
                if (!role.getRolename().equals(rolename)) continue;
                return true;
            }
        }
        return false;
    }

    public synchronized boolean isSignedIn() {
        return this.userId != null;
    }

    public synchronized void onSignOut() {
    }

    public synchronized Serializable removeUserAttribute(String key) {
        return this.userAttributes.remove(key);
    }

    public synchronized void setRoles(List<Roles> roles) {
        this.roles = roles;
    }

    public abstract void setUser(Users var1);

    public synchronized void setUserAttribute(String key, Serializable value) {
        this.userAttributes.put(key, value);
    }

    public synchronized void setUserId(USERID userId) {
        this.userId = userId;
    }
}

