/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.time.query;

import java.time.LocalDate;
import java.time.Period;
import java.time.temporal.TemporalAccessor;
import java.time.temporal.TemporalQuery;

public class NextEasternQuery
implements TemporalQuery<LocalDate> {
    private int computeEasternSundayNumber(int year) {
        int i = year % 19;
        int j = year / 100;
        int k = year % 100;
        int l = (19 * i + j - j / 4 - (j - (j + 8) / 25 + 1) / 3 + 15) % 30;
        int m = (32 + 2 * (j % 4) + 2 * (k / 4) - l - k % 4) % 7;
        return l + m - 7 * ((i + 11 * l + 22 * m) / 451) + 114;
    }

    private LocalDate getEasternDateInYear(int year) {
        int easternSundayNumber = this.computeEasternSundayNumber(year);
        int month = easternSundayNumber / 31;
        int day = easternSundayNumber % 31 + 1;
        return LocalDate.of(year, month, day);
    }

    @Override
    public LocalDate queryFrom(TemporalAccessor temporal) {
        LocalDate currentYearEasternSunday;
        LocalDate date = LocalDate.from(temporal);
        Period periodToCurrentYearEasternSunday = Period.between(date, currentYearEasternSunday = this.getEasternDateInYear(date.getYear()));
        if (periodToCurrentYearEasternSunday.isNegative() || periodToCurrentYearEasternSunday.isZero()) {
            return this.getEasternDateInYear(date.getYear() + 1);
        }
        return currentYearEasternSunday;
    }
}

