/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.time.gap;

import java.time.LocalDate;
import java.time.temporal.ChronoUnit;
import lombok.NonNull;

public final class TimeGapExtensions {
    public static boolean isBeforeTimeGap(LocalDate localDate, LocalDate otherLocalDate, @NonNull ChronoUnit chronoUnit) {
        if (chronoUnit == null) {
            throw new NullPointerException("chronoUnit is marked @NonNull but is null");
        }
        long between = chronoUnit.between(localDate, otherLocalDate);
        return between < -1L;
    }

    public static boolean isAfterTimeGap(LocalDate localDate, LocalDate otherLocalDate, @NonNull ChronoUnit chronoUnit) {
        if (chronoUnit == null) {
            throw new NullPointerException("chronoUnit is marked @NonNull but is null");
        }
        long between = chronoUnit.between(localDate, otherLocalDate);
        return 1L < between;
    }

    private TimeGapExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

