/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.throwable;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.StringWriter;
import lombok.NonNull;

public final class ThrowableExtensions {
    public static String getStackTrace(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked @NonNull but is null");
        }
        StringBuilder stacktrace = new StringBuilder();
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            throwable.printStackTrace(pw);
            stacktrace.append(sw.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stacktrace.toString();
    }

    public static String getStackTraceElements(@NonNull Throwable throwable) {
        if (throwable == null) {
            throw new NullPointerException("throwable is marked @NonNull but is null");
        }
        StringBuilder stacktrace = new StringBuilder();
        try (StringWriter sw = new StringWriter();
             PrintWriter pw = new PrintWriter(sw);){
            pw.println(throwable.getClass().toString());
            while (throwable != null) {
                StackTraceElement[] stackTraceElements;
                pw.println(throwable);
                for (StackTraceElement stackTraceElement : stackTraceElements = throwable.getStackTrace()) {
                    pw.println("\tat " + stackTraceElement);
                }
                if ((throwable = throwable.getCause()) == null) continue;
                pw.println("Caused by:\r\n");
            }
            stacktrace.append(sw.toString());
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return stacktrace.toString();
    }

    private ThrowableExtensions() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

