/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.test.objects;

import de.alpharogroup.test.objects.Employee;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;

public class EmployeeList {
    private List<Employee> employees;

    public static EmployeeListBuilder builder() {
        return new EmployeeListBuilder();
    }

    public EmployeeListBuilder toBuilder() {
        EmployeeListBuilder builder = new EmployeeListBuilder();
        if (this.employees != null) {
            builder.employees(this.employees);
        }
        return builder;
    }

    public List<Employee> getEmployees() {
        return this.employees;
    }

    public void setEmployees(List<Employee> employees) {
        this.employees = employees;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EmployeeList)) {
            return false;
        }
        EmployeeList other = (EmployeeList)o;
        if (!other.canEqual(this)) {
            return false;
        }
        List<Employee> this$employees = this.getEmployees();
        List<Employee> other$employees = other.getEmployees();
        return !(this$employees == null ? other$employees != null : !((Object)this$employees).equals(other$employees));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EmployeeList;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        List<Employee> $employees = this.getEmployees();
        result = result * 59 + ($employees == null ? 43 : ((Object)$employees).hashCode());
        return result;
    }

    public String toString() {
        return "EmployeeList(employees=" + this.getEmployees() + ")";
    }

    public EmployeeList() {
    }

    public EmployeeList(List<Employee> employees) {
        this.employees = employees;
    }

    public static class EmployeeListBuilder {
        private ArrayList<Employee> employees;

        EmployeeListBuilder() {
        }

        public EmployeeListBuilder employee(Employee employee) {
            if (this.employees == null) {
                this.employees = new ArrayList();
            }
            this.employees.add(employee);
            return this;
        }

        public EmployeeListBuilder employees(Collection<? extends Employee> employees) {
            if (this.employees == null) {
                this.employees = new ArrayList();
            }
            this.employees.addAll(employees);
            return this;
        }

        public EmployeeListBuilder clearEmployees() {
            if (this.employees != null) {
                this.employees.clear();
            }
            return this;
        }

        public EmployeeList build() {
            List<Employee> employees;
            switch (this.employees == null ? 0 : this.employees.size()) {
                case 0: {
                    employees = Collections.emptyList();
                    break;
                }
                case 1: {
                    employees = Collections.singletonList(this.employees.get(0));
                    break;
                }
                default: {
                    employees = Collections.unmodifiableList(new ArrayList<Employee>(this.employees));
                }
            }
            return new EmployeeList(employees);
        }

        public String toString() {
            return "EmployeeList.EmployeeListBuilder(employees=" + this.employees + ")";
        }
    }
}

