/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup;

import de.alpharogroup.AbstractTestCase;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import org.testng.AssertJUnit;
import org.testng.annotations.AfterMethod;
import org.testng.annotations.BeforeMethod;

public abstract class BaseComparatorTestCase<T>
extends AbstractTestCase<Integer, Boolean> {
    protected Comparator<T> comparator;
    protected T o1;
    protected T o2;

    protected abstract List<T> newActualList();

    protected abstract Comparator<T> newComparator();

    protected abstract List<T> newExpectedSortedList();

    protected abstract List<T> newExpectedUnsortedList();

    protected abstract T newO1Equal();

    protected abstract T newO1GreaterThan();

    protected abstract T newO1LessThan();

    protected T newO2Equal() {
        return this.newO1Equal();
    }

    protected abstract T newO2GreaterThan();

    protected abstract T newO2LessThan();

    @Override
    @BeforeMethod
    public void setUp() {
        this.comparator = this.newComparator();
    }

    @Override
    @AfterMethod
    public void tearDown() {
        this.comparator = null;
        this.o1 = null;
        this.o2 = null;
    }

    public void testCompare() {
        int i;
        List<T> actual = this.newActualList();
        List<T> expected = this.newExpectedUnsortedList();
        for (i = 0; i < actual.size(); ++i) {
            AssertJUnit.assertEquals(expected.get(i), actual.get(i));
        }
        Collections.sort(actual, this.comparator);
        expected = this.newExpectedSortedList();
        for (i = 0; i < actual.size(); ++i) {
            AssertJUnit.assertEquals(expected.get(i), actual.get(i));
        }
    }

    public void testEqual() {
        this.o1 = this.newO1Equal();
        this.o2 = this.newO2Equal();
        this.actual = this.comparator.compare(this.o1, this.o2);
        this.expected = (Integer)this.actual == 0;
        AssertJUnit.assertTrue((boolean)((Boolean)this.expected));
        this.o1 = this.newO1Equal();
        this.o2 = this.o1;
        this.actual = this.comparator.compare(this.o1, this.o2);
        this.expected = (Integer)this.actual == 0;
        AssertJUnit.assertTrue((boolean)((Boolean)this.expected));
    }

    public void testGreaterThan() {
        this.o1 = this.newO1GreaterThan();
        this.o2 = this.newO2GreaterThan();
        this.actual = this.comparator.compare(this.o1, this.o2);
        this.expected = (Integer)this.actual > 0;
        AssertJUnit.assertTrue((boolean)((Boolean)this.expected));
        this.o1 = this.newO1GreaterThan();
        this.o2 = null;
        this.actual = this.comparator.compare(this.o1, this.o2);
        this.expected = (Integer)this.actual > 0;
        AssertJUnit.assertTrue((boolean)((Boolean)this.expected));
    }

    public void testLessThan() {
        this.o1 = this.newO1LessThan();
        this.o2 = this.newO2LessThan();
        this.actual = this.comparator.compare(this.o1, this.o2);
        this.expected = (Integer)this.actual < 0;
        AssertJUnit.assertTrue((boolean)((Boolean)this.expected));
        this.o1 = null;
        this.o2 = this.newO2LessThan();
        this.actual = this.comparator.compare(this.o1, this.o2);
        this.expected = (Integer)this.actual < 0;
        AssertJUnit.assertTrue((boolean)((Boolean)this.expected));
    }
}

