/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.classes.inner;

import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OuterClass {
    private static final Logger log = LoggerFactory.getLogger(OuterClass.class);

    public static void main(String ... args) {
        StaticNestedClass.staticNestedClassMethod();
        OuterClass.showInfo(OuterClass.class);
        OuterClass.showInfo(InnerClass.class);
        OuterClass.showInfo(StaticNestedClass.class);
    }

    public static void showInfo(Class<?> clazz) {
        log.info("========================================================================");
        log.info("class name is {}.", (Object)clazz.getName());
        log.info("= = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = = ");
        log.info("is class {} anonymous class:{}", (Object)clazz.getSimpleName(), (Object)clazz.isAnonymousClass());
        log.info("is class {} synthetic class:{}", (Object)clazz.getSimpleName(), (Object)clazz.isSynthetic());
        log.info("is class {} enclosing class:{}", (Object)clazz.getSimpleName(), clazz.getEnclosingClass());
        log.info("canonical name of class {}:{}", (Object)clazz.getSimpleName(), (Object)clazz.getCanonicalName());
        log.info("enclosing method:{}", (Object)clazz.getEnclosingMethod());
        log.info("========================================================================");
    }

    static class StaticNestedClass {
        StaticNestedClass() {
        }

        public static void staticNestedClassMethod() {
            Runnable runnable = new Runnable(){

                @Override
                public void run() {
                }
            };
            OuterClass.showInfo(runnable.getClass());
        }
    }

    public class InnerClass {
    }
}

