/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.test.objects.evaluations;

import java.lang.reflect.Method;

public final class ToStringEvaluator {
    public static boolean evaluate(Class<?> clazz) {
        Method toString;
        try {
            toString = clazz.getDeclaredMethod("toString", new Class[0]);
        }
        catch (NoSuchMethodException ex) {
            return false;
        }
        return String.class.equals(toString.getReturnType());
    }

    public static <T> boolean evaluateConsistency(T object) {
        return ToStringEvaluator.evaluateConsistency(object, 7);
    }

    public static <T> boolean evaluateConsistency(T object, int iterations) {
        if (object == null) {
            return false;
        }
        String initialToStringResult = object.toString();
        boolean valid = true;
        for (int i = 0; i < iterations; ++i) {
            String currentToStringResult = object.toString();
            if (initialToStringResult.equals(currentToStringResult)) continue;
            return false;
        }
        return valid;
    }

    private ToStringEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

