/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.test.objects.evaluations;

public final class EqualsEvaluator {
    public static boolean evaluateReflexivity(Object object) {
        if (object == null) {
            return false;
        }
        return object.equals(object);
    }

    public static boolean evaluateSymmetric(Object object, Object anotherObject) {
        if (object == null) {
            return false;
        }
        boolean even = object.equals(anotherObject);
        boolean odd = anotherObject.equals(object);
        return even && odd;
    }

    public static boolean evaluateTransitivity(Object a, Object b, Object c) {
        if (a == null) {
            return false;
        }
        boolean aEqualsB = a.equals(b);
        boolean bEqualsC = b.equals(c);
        boolean aEqualsC = a.equals(c);
        return aEqualsB && bEqualsC && aEqualsC;
    }

    public static boolean evaluateNonNull(Object object) {
        if (object == null) {
            return false;
        }
        boolean result = !object.equals(null);
        return result;
    }

    public static <T> boolean evaluateConsistency(T object, T anotherObject) {
        return EqualsEvaluator.evaluateConsistency(object, anotherObject, 7);
    }

    public static <T> boolean evaluateConsistency(T object, T anotherObject, int iterations) {
        if (object == null) {
            return false;
        }
        boolean initialEqualsResult = object.equals(anotherObject);
        boolean valid = true;
        for (int i = 0; i < iterations; ++i) {
            boolean currentEqualsResult = object.equals(anotherObject);
            if (initialEqualsResult == currentEqualsResult) continue;
            return false;
        }
        return valid;
    }

    private EqualsEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

