/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.test.objects.evaluations;

public final class ComparableEvaluator {
    public static <T extends Comparable<T>> boolean evaluateConsistency(T object, T anotherObject) {
        boolean equal = object.equals(anotherObject);
        boolean compareTo = object.compareTo(anotherObject) == 0;
        return equal && compareTo;
    }

    public static <T extends Comparable<T>> boolean evaluateReversalComparison(T object, T anotherObject) {
        return Math.signum(object.compareTo(anotherObject)) == -Math.signum(anotherObject.compareTo(object));
    }

    public static <T extends Comparable<T>> boolean evaluateTransitivity(T a, T b, T c) {
        return 0 <= b.compareTo(a) && 0 <= c.compareTo(b) && 0 <= c.compareTo(a);
    }

    private ComparableEvaluator() {
        throw new UnsupportedOperationException("This is a utility class and cannot be instantiated");
    }
}

