/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.utils;

import de.alpharogroup.lang.ClassExtensions;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.HeadlessException;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.datatransfer.Clipboard;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import javax.imageio.ImageIO;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JOptionPane;

public final class AwtExtensions {
    public static Component getRootJDialog(Component component) {
        while (null != component.getParent() && !((component = component.getParent()) instanceof JDialog)) {
        }
        return component;
    }

    public static Component getRootJFrame(Component component) {
        while (null != component.getParent() && !((component = component.getParent()) instanceof JFrame)) {
        }
        return component;
    }

    public static Component getRootParent(Component component) {
        while (null != component.getParent()) {
            component = component.getParent();
        }
        return component;
    }

    public static Window getWindowForComponent(Component component) throws HeadlessException {
        if (component == null) {
            return JOptionPane.getRootFrame();
        }
        if (component instanceof Frame || component instanceof Dialog) {
            return (Window)component;
        }
        return AwtExtensions.getWindowForComponent(component.getParent());
    }

    public static Cursor newInvisibleCursor() {
        return Toolkit.getDefaultToolkit().createCustomCursor(Toolkit.getDefaultToolkit().createImage(new byte[0]), new Point(0, 0), "InvisibleCursor");
    }

    public static void setIconImage(String resourceName, Window window) throws IOException {
        InputStream isLogo = ClassExtensions.getResourceAsStream((String)resourceName);
        BufferedImage biLogo = ImageIO.read(isLogo);
        window.setIconImage(biLogo);
    }

    public static Clipboard getSystemClipboard() {
        return Toolkit.getDefaultToolkit().getSystemClipboard();
    }
}

