/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.table.model.dynamic;

import de.alpharogroup.swing.table.model.GenericTableModel;
import de.alpharogroup.swing.table.model.dynamic.DynamicTableColumnsModel;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import lombok.NonNull;

public abstract class DynamicTableModel<T>
extends GenericTableModel<T> {
    private static final Logger log = Logger.getLogger(DynamicTableModel.class.getName());
    private static final long serialVersionUID = 1L;
    private final DynamicTableColumnsModel<T> columnsModel;

    public DynamicTableModel(@NonNull DynamicTableColumnsModel<T> columnsModel) {
        if (columnsModel == null) {
            throw new NullPointerException("columnsModel is marked non-null but is null");
        }
        this.columnsModel = columnsModel;
    }

    public DynamicTableModel(List<T> list, @NonNull DynamicTableColumnsModel<T> columnsModel) {
        super(list);
        if (columnsModel == null) {
            throw new NullPointerException("columnsModel is marked non-null but is null");
        }
        this.columnsModel = columnsModel;
    }

    @Override
    public Class<?> getColumnClass(int c) {
        try {
            return this.columnsModel.getColumnClasses()[c];
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error occured on getting column class on index " + c + ".", e);
            return null;
        }
    }

    @Override
    public int getColumnCount() {
        return this.columnsModel.getColumnNames().length;
    }

    @Override
    public String getColumnName(int col) {
        try {
            return this.columnsModel.getColumnNames()[col];
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error occured on getting column name on index " + col + ".", e);
            return null;
        }
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        try {
            return this.columnsModel.getCanEdit()[columnIndex];
        }
        catch (Exception e) {
            log.log(Level.SEVERE, "Error occured on getting flag if the cell is editable at position on row: " + rowIndex + " and in column: " + columnIndex + ".", e);
            return false;
        }
    }

    public DynamicTableColumnsModel<T> getColumnsModel() {
        return this.columnsModel;
    }
}

