/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.table.model.dynamic;

import de.alpharogroup.collections.list.ListFactory;
import de.alpharogroup.reflection.ReflectionExtensions;
import java.lang.reflect.Field;
import java.util.Arrays;
import java.util.List;
import lombok.NonNull;
import org.apache.commons.lang3.StringUtils;

public class DynamicTableColumnsModel<T> {
    private boolean[] canEdit;
    private Class<?>[] columnClasses;
    private String[] columnNames;
    @NonNull
    private final Class<T> type;

    public DynamicTableColumnsModel(@NonNull Class<T> type) {
        if (type == null) {
            throw new NullPointerException("type is marked non-null but is null");
        }
        this.type = type;
        this.onSetColumnNames();
        this.onSetColumnClasses();
        this.onSetCanEdit();
    }

    private Field[] getFields() {
        return ReflectionExtensions.getAllDeclaredFields(this.getType(), (String[])new String[]{"serialVersionUID", "$jacocoData"});
    }

    protected void onSetCanEdit() {
        Field[] fields = this.getFields();
        this.canEdit = new boolean[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.canEdit[i] = false;
        }
    }

    protected void onSetColumnClasses() {
        Field[] fields = this.getFields();
        this.columnClasses = new Class[fields.length];
        for (int i = 0; i < fields.length; ++i) {
            this.columnClasses[i] = fields[i].getType();
        }
    }

    protected void onSetColumnNames() {
        this.columnNames = ReflectionExtensions.getAllDeclaredFieldNames(this.getType(), (List)ListFactory.newArrayList((Object[])new String[]{"serialVersionUID", "$jacocoData"}));
        for (int i = 0; i < this.columnNames.length; ++i) {
            this.columnNames[i] = StringUtils.capitalize((String)this.columnNames[i]);
        }
    }

    public boolean[] getCanEdit() {
        return this.canEdit;
    }

    public Class<?>[] getColumnClasses() {
        return this.columnClasses;
    }

    public String[] getColumnNames() {
        return this.columnNames;
    }

    @NonNull
    public Class<T> getType() {
        return this.type;
    }

    public DynamicTableColumnsModel<T> setCanEdit(boolean[] canEdit) {
        this.canEdit = canEdit;
        return this;
    }

    public DynamicTableColumnsModel<T> setColumnClasses(Class<?>[] columnClasses) {
        this.columnClasses = columnClasses;
        return this;
    }

    public DynamicTableColumnsModel<T> setColumnNames(String[] columnNames) {
        this.columnNames = columnNames;
        return this;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof DynamicTableColumnsModel)) {
            return false;
        }
        DynamicTableColumnsModel other = (DynamicTableColumnsModel)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (!Arrays.equals(this.getCanEdit(), other.getCanEdit())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColumnClasses(), other.getColumnClasses())) {
            return false;
        }
        if (!Arrays.deepEquals(this.getColumnNames(), other.getColumnNames())) {
            return false;
        }
        Class<T> this$type = this.getType();
        Class<T> other$type = other.getType();
        return !(this$type == null ? other$type != null : !this$type.equals(other$type));
    }

    protected boolean canEqual(Object other) {
        return other instanceof DynamicTableColumnsModel;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + Arrays.hashCode(this.getCanEdit());
        result = result * 59 + Arrays.deepHashCode(this.getColumnClasses());
        result = result * 59 + Arrays.deepHashCode(this.getColumnNames());
        Class<T> $type = this.getType();
        result = result * 59 + ($type == null ? 43 : $type.hashCode());
        return result;
    }

    public String toString() {
        return "DynamicTableColumnsModel(canEdit=" + Arrays.toString(this.getCanEdit()) + ", columnClasses=" + Arrays.deepToString(this.getColumnClasses()) + ", columnNames=" + Arrays.deepToString(this.getColumnNames()) + ", type=" + this.getType() + ")";
    }
}

