/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.table.editor;

import java.awt.Component;
import javax.swing.DefaultCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JOptionPane;
import javax.swing.JTable;

public class TableCellCheckboxEditor
extends DefaultCellEditor {
    private static final long serialVersionUID = 1L;
    private JCheckBox button;
    private boolean clicked;
    private int column;
    private int row;
    private Object value;

    public TableCellCheckboxEditor(JCheckBox checkBox) {
        super(checkBox);
        this.setButton(new JCheckBox());
        this.getButton().setOpaque(true);
        this.getButton().addActionListener(e -> {
            this.onClick();
            this.fireEditingStopped();
        });
    }

    @Override
    public Object getCellEditorValue() {
        if (this.isClicked()) {
            JOptionPane.showMessageDialog(this.button, "You clicked the button with the value " + this.value + " in row index " + this.row + " and in colunm index " + this.column + ".");
        }
        this.setClicked(false);
        String text = "";
        if (this.getValue() != null) {
            text = this.getValue().toString();
        }
        return text;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.setRow(row);
        this.setColumn(column);
        this.setValue(value);
        if (isSelected) {
            this.getButton().setForeground(table.getSelectionForeground());
            this.getButton().setBackground(table.getSelectionBackground());
        } else {
            this.getButton().setForeground(table.getForeground());
            this.getButton().setBackground(table.getBackground());
        }
        String text = "";
        if (value != null) {
            text = this.getValue().toString();
        }
        this.getButton().setText(text);
        this.setClicked(true);
        return this.getButton();
    }

    protected void onClick() {
    }

    @Override
    public boolean stopCellEditing() {
        this.setClicked(false);
        return super.stopCellEditing();
    }

    public JCheckBox getButton() {
        return this.button;
    }

    public boolean isClicked() {
        return this.clicked;
    }

    public int getColumn() {
        return this.column;
    }

    public int getRow() {
        return this.row;
    }

    public Object getValue() {
        return this.value;
    }

    public TableCellCheckboxEditor setButton(JCheckBox button) {
        this.button = button;
        return this;
    }

    public TableCellCheckboxEditor setClicked(boolean clicked) {
        this.clicked = clicked;
        return this;
    }

    public TableCellCheckboxEditor setColumn(int column) {
        this.column = column;
        return this;
    }

    public TableCellCheckboxEditor setRow(int row) {
        this.row = row;
        return this;
    }

    public TableCellCheckboxEditor setValue(Object value) {
        this.value = value;
        return this;
    }
}

