/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.splashscreen;

import de.alpharogroup.layout.ScreenSizeExtensions;
import java.awt.BorderLayout;
import java.awt.Dimension;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JWindow;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class SplashScreen
extends JWindow {
    private static final long serialVersionUID = 4667236770554004675L;
    private boolean showing;

    public SplashScreen(String image, String text) {
        JPanel contentPane = new JPanel();
        contentPane.setLayout(new BorderLayout());
        Border bd1 = BorderFactory.createBevelBorder(0);
        Border bd2 = BorderFactory.createEtchedBorder();
        CompoundBorder bd3 = BorderFactory.createCompoundBorder(bd1, bd2);
        contentPane.setBorder(bd3);
        ImageIcon icon = new ImageIcon(image);
        contentPane.add("North", new JLabel(" ", 0));
        contentPane.add("Center", new JLabel(icon, 0));
        contentPane.add("South", new JLabel(text, 0));
        this.setContentPane(contentPane);
    }

    @Override
    public boolean isShowing() {
        return this.showing;
    }

    public void setShowing(boolean showing) {
        this.showing = showing;
    }

    public void showFor(int millis) {
        this.setVisible(true);
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setVisible(false);
    }

    public void showing() {
        Dimension dim = new Dimension(ScreenSizeExtensions.getScreenWidth(this), ScreenSizeExtensions.getScreenHeight(this));
        this.setLocation(dim.width / 3, dim.height / 3);
        this.setSize(dim.width / 3, dim.height / 3);
        this.setVisible(true);
        this.toFront();
        while (this.showing) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException interruptedException) {}
        }
        this.setVisible(false);
    }
}

