/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.splashscreen;

import de.alpharogroup.lang.ClassExtensions;
import de.alpharogroup.layout.ScreenSizeExtensions;
import de.alpharogroup.model.api.Model;
import de.alpharogroup.swing.base.BaseWindow;
import de.alpharogroup.swing.splashscreen.SplashScreenModelBean;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Image;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;
import javax.swing.border.CompoundBorder;

public class BaseSplashScreen
extends BaseWindow<SplashScreenModelBean> {
    private static final long serialVersionUID = 1L;
    private JPanel contentPanel;
    private final JFrame frame;
    private ImageIcon icon;
    private JLabel iconLabel;
    private JLabel textLabel;

    public BaseSplashScreen(JFrame frame, Model<SplashScreenModelBean> model) {
        super(frame, model);
        this.frame = frame;
    }

    private BufferedImage getBufferedImage() throws IOException {
        InputStream stream = ClassExtensions.getResourceAsStream((String)((SplashScreenModelBean)this.getModelObject()).getImagePath());
        BufferedImage image = ImageIO.read(stream);
        return image;
    }

    private void initIcon() throws IOException {
        URL imageResource = ClassLoader.getSystemResource(((SplashScreenModelBean)this.getModelObject()).getImagePath());
        if (imageResource == null) {
            BufferedImage image = this.getBufferedImage();
            this.icon = new ImageIcon(image);
        } else {
            this.icon = new ImageIcon(imageResource);
        }
    }

    protected JPanel newContentPanel() {
        return new JPanel();
    }

    protected JLabel newIconLabel(ImageIcon icon) {
        return new JLabel(icon, 0);
    }

    protected JLabel newTextLabel(Model<SplashScreenModelBean> model) {
        return new JLabel(((SplashScreenModelBean)this.getModel().getObject()).getText(), 0);
    }

    @Override
    protected void onAfterInitialize() {
        super.onAfterInitialize();
        this.showFor(((SplashScreenModelBean)this.getModelObject()).getShowTime());
    }

    @Override
    protected void onInitializeComponents() {
        super.onInitializeComponents();
        try {
            this.initIcon();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.contentPanel = this.newContentPanel();
        this.textLabel = this.newTextLabel(this.getModel());
        this.iconLabel = this.newIconLabel(this.icon);
    }

    @Override
    protected void onInitializeLayout() {
        super.onInitializeLayout();
        this.setContentPane(this.contentPanel);
        this.contentPanel.setLayout(new BorderLayout());
        Border bd1 = BorderFactory.createBevelBorder(0);
        Border bd2 = BorderFactory.createEtchedBorder();
        CompoundBorder bd3 = BorderFactory.createCompoundBorder(bd1, bd2);
        this.contentPanel.setBorder(bd3);
        this.contentPanel.add((Component)this.textLabel, "North");
        this.contentPanel.add((Component)this.iconLabel, "Center");
        this.onSetLocationAndSize();
        this.setVisible(true);
        this.resizeIconLabel();
    }

    protected void onSetLocationAndSize() {
        ScreenSizeExtensions.centralize(this, 3, 3);
    }

    private void resizeIconLabel() {
        try {
            BufferedImage img = this.getBufferedImage();
            Image dimg = img.getScaledInstance(this.iconLabel.getWidth(), this.iconLabel.getHeight(), 4);
            this.icon = new ImageIcon(dimg);
            this.iconLabel.setIcon(this.icon);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void showFor(int millis) {
        this.setVisible(true);
        try {
            Thread.sleep(millis);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        this.setVisible(false);
    }

    public JPanel getContentPanel() {
        return this.contentPanel;
    }

    public JFrame getFrame() {
        return this.frame;
    }

    public ImageIcon getIcon() {
        return this.icon;
    }

    public JLabel getIconLabel() {
        return this.iconLabel;
    }

    public JLabel getTextLabel() {
        return this.textLabel;
    }
}

