/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.robot;

import de.alpharogroup.random.SecureRandomFactory;
import java.awt.Robot;
import java.awt.event.KeyEvent;
import java.lang.reflect.Field;
import java.security.SecureRandom;

public class RobotExtensions {
    public static int getKeyCode(char character) throws IllegalAccessException, NoSuchFieldException {
        String c = String.valueOf(character).toUpperCase();
        String variableName = "VK_" + c;
        Class<KeyEvent> clazz = KeyEvent.class;
        Field field = clazz.getField(variableName);
        int keyCode = field.getInt(null);
        return keyCode;
    }

    public static void infiniteMoveMouse(Robot robot, int x, int y, long everyMilliSeconds) throws InterruptedException {
        SecureRandom secureRandom = SecureRandomFactory.newSecureRandom();
        while (true) {
            robot.mouseMove(secureRandom.nextInt(x), secureRandom.nextInt(y));
            Thread.sleep(everyMilliSeconds);
        }
    }

    public static void moveMouseForSpecificDuration(Robot robot, int x, int y, long everyMilliSeconds, long duration) throws InterruptedException {
        SecureRandom secureRandom = SecureRandomFactory.newSecureRandom();
        for (long counter = 0L; counter < duration; counter += everyMilliSeconds) {
            robot.mouseMove(secureRandom.nextInt(x), secureRandom.nextInt(y));
            Thread.sleep(everyMilliSeconds);
        }
    }

    public static void typeCharacter(Robot robot, char character) throws IllegalAccessException, NoSuchFieldException {
        boolean upperCase = Character.isUpperCase(character);
        int keyCode = RobotExtensions.getKeyCode(character);
        if (upperCase) {
            robot.keyPress(16);
        }
        robot.keyPress(keyCode);
        robot.keyRelease(keyCode);
        if (upperCase) {
            robot.keyRelease(16);
        }
    }

    public static void typeString(Robot robot, String input) throws NoSuchFieldException, IllegalAccessException {
        if (input != null && !input.isEmpty()) {
            for (char character : input.toCharArray()) {
                RobotExtensions.typeCharacter(robot, character);
            }
        }
    }
}

