/*
 * Decompiled with CFR 0.152.
 */
package de.alpharogroup.swing.plaf;

import java.awt.Component;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import lombok.NonNull;

public enum LookAndFeels {
    GTK("com.sun.java.swing.plaf.gtk.GTKLookAndFeel"),
    METAL("javax.swing.plaf.metal.MetalLookAndFeel"),
    OCEAN("javax.swing.plaf.metal.OceanTheme"),
    MOTIF("com.sun.java.swing.plaf.motif.MotifLookAndFeel"),
    MULTI("javax.swing.plaf.multi.MultiLookAndFeel"),
    NIMBUS("javax.swing.plaf.nimbus.NimbusLookAndFeel"),
    SYNTH("javax.swing.plaf.synth.SynthLookAndFeel"),
    SYSTEM(UIManager.getSystemLookAndFeelClassName()),
    WINDOWS("com.sun.java.swing.plaf.windows.WindowsLookAndFeel");

    private static final String LOOK_AND_FEEL_GTK = "com.sun.java.swing.plaf.gtk.GTKLookAndFeel";
    private static final String LOOK_AND_FEEL_METAL = "javax.swing.plaf.metal.MetalLookAndFeel";
    private static final String LOOK_AND_FEEL_METAL_OCEAN = "javax.swing.plaf.metal.OceanTheme";
    private static final String LOOK_AND_FEEL_MOTIF = "com.sun.java.swing.plaf.motif.MotifLookAndFeel";
    private static final String LOOK_AND_FEEL_MULTI = "javax.swing.plaf.multi.MultiLookAndFeel";
    private static final String LOOK_AND_FEEL_NIMBUS = "javax.swing.plaf.nimbus.NimbusLookAndFeel";
    private static final String LOOK_AND_FEEL_SYNTH = "javax.swing.plaf.synth.SynthLookAndFeel";
    private static final String LOOK_AND_FEEL_WINDOWS = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
    private final String lookAndFeelName;

    public static LookAndFeels setLookAndFeel(@NonNull LookAndFeels lookAndFeels, @NonNull Component component) throws ClassNotFoundException, InstantiationException, IllegalAccessException, UnsupportedLookAndFeelException {
        if (lookAndFeels == null) {
            throw new NullPointerException("lookAndFeels is marked non-null but is null");
        }
        if (component == null) {
            throw new NullPointerException("component is marked non-null but is null");
        }
        UIManager.setLookAndFeel(lookAndFeels.getLookAndFeelName());
        SwingUtilities.updateComponentTreeUI(component);
        return lookAndFeels;
    }

    private LookAndFeels(String lookAndFeelName) {
        this.lookAndFeelName = lookAndFeelName;
    }

    public String getLookAndFeelName() {
        return this.lookAndFeelName;
    }
}

